/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network.hookauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.github.kloping.io.ReadUtils;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.network.AuthAndHeartbeat;
import io.github.kloping.qqbot.network.WssWorker;
import io.github.kloping.qqbot.network.hookauth.CustomPrivateKey;
import io.github.kloping.qqbot.network.hookauth.CustomPublicKey;
import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.interfaces.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

@Entity
public class HookAuth {
    @AutoStand
    private Logger logger;
    @AutoStand
    WssWorker wssWorker;
    @AutoStand
    Starter.Config config;

    public void webhookServerStart() {
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(this.config.getWebhookport()), 0);
            server.createContext(this.config.getWebhookpath(), exchange -> {
                String body = ReadUtils.readAll((InputStream)exchange.getRequestBody(), (String)"UTF-8");
                this.logger.log(String.format("webhook-r: %s", body));
                Pack pack = (Pack)Resource.GSON.fromJson(body, Pack.class);
                String resp = null;
                if (pack.getOp() == 13) {
                    resp = this.auth(body, pack, exchange);
                } else {
                    try {
                        Object sigs = exchange.getRequestHeaders().get("X-Signature-Ed25519");
                        Object ts = exchange.getRequestHeaders().get("X-Signature-Timestamp");
                        String sig = (String)sigs.get(0);
                        String timestamp = (String)ts.get(0);
                        KeyPair keyPair = this.getKeyPair();
                        boolean isValid = this.verifySignature(sig, timestamp, body.getBytes(StandardCharsets.UTF_8), keyPair.getPublic().getEncoded());
                        resp = String.valueOf(isValid);
                    }
                    catch (Exception e) {
                        this.logger.error("\u9a8c\u8bc1\u7b7e\u540d\u62a5\u9519(\u4e0d\u5f71\u54cd\u63a5\u6536\u548c\u53d1\u9001)\uff1a\n" + PartUtils.getExceptionLine((Throwable)e));
                    }
                    this.wssWorker.getOnPackReceives().stream().filter(o -> !(o instanceof AuthAndHeartbeat)).forEach(p -> p.onReceive(pack));
                }
                this.logger.log("WebHook\u670d\u52a1\u54cd\u5e94: " + resp);
                exchange.sendResponseHeaders(200, resp.length());
                exchange.getResponseBody().write(resp.getBytes("UTF-8"));
            });
            server.start();
            this.logger.info(String.format("Bot(%s) webhook server started! By kloping of qqpd-bot-java v1.5.3-R1", this.config.getAppid()));
        }
        catch (IOException e) {
            this.logger.error("\u5728WebHook\u670d\u52a1\u542f\u52a8\u65f6\u5931\u8d25\n" + PartUtils.getExceptionLine((Throwable)e));
        }
    }

    private KeyPair getKeyPair() {
        return this.generateEd25519KeyPair(this.prepareSeed(this.config.getSecret()).getBytes(StandardCharsets.UTF_8));
    }

    private String auth(String body, Pack pack, HttpExchange exchange) {
        try {
            this.logger.info("\u9a8c\u8bc1\u6709\u6548\u6027...");
            KeyPair keyPair = this.getKeyPair();
            Map packD = (Map)pack.getD();
            String plain_token = (String)packD.get("plain_token");
            String event_ts = (String)packD.get("event_ts");
            byte[] message = (event_ts + plain_token).getBytes(StandardCharsets.UTF_8);
            byte[] signature = this.signMessage(keyPair.getPrivate(), message);
            return String.format("{\"plain_token\": \"%s\", \"signature\": \"%s\"}", plain_token, this.bytesToHex(signature));
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u5931\u8d25\uff1a\n" + PartUtils.getExceptionLine((Throwable)e));
            return "{}";
        }
    }

    public boolean verifySignature(String signatureHex, String timestamp, byte[] httpBody, byte[] publicKeyBytes) {
        try {
            byte[] sig = Hex.decode((String)signatureHex);
            if (sig.length != 64 || (sig[63] & 0xE0) != 0) {
                this.logger.waring("Invalid signature format");
                return false;
            }
            ByteArrayOutputStream msg = new ByteArrayOutputStream();
            msg.write(timestamp.getBytes(StandardCharsets.UTF_8));
            msg.write(httpBody);
            Ed25519Signer verifier = new Ed25519Signer();
            verifier.init(false, (CipherParameters)new Ed25519PublicKeyParameters(publicKeyBytes, 0));
            verifier.update(msg.toByteArray(), 0, msg.size());
            return verifier.verifySignature(sig);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u7b7e\u540d\u62a5\u9519\uff1a\n" + PartUtils.getExceptionLine((Throwable)e));
            return false;
        }
    }

    private String prepareSeed(String seed) {
        if (seed.length() < 32) {
            seed = HookAuth.repeat(seed, 2);
        }
        return seed.substring(0, 32);
    }

    private KeyPair generateEd25519KeyPair(byte[] seed) {
        Ed25519KeyPairGenerator generator = new Ed25519KeyPairGenerator();
        generator.init(new KeyGenerationParameters(null, 32));
        Ed25519PrivateKeyParameters privateKeyParams = new Ed25519PrivateKeyParameters(seed, 0);
        Ed25519PublicKeyParameters publicKeyParams = privateKeyParams.generatePublicKey();
        byte[] privateKeyBytes = privateKeyParams.getEncoded();
        byte[] publicKeyBytes = publicKeyParams.getEncoded();
        return new KeyPair(new CustomPublicKey(publicKeyBytes), new CustomPrivateKey(privateKeyBytes));
    }

    private byte[] signMessage(PrivateKey privateKey, byte[] message) {
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)new Ed25519PrivateKeyParameters(privateKey.getEncoded(), 0));
        signer.update(message, 0, message.length);
        return signer.generateSignature();
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String repeat(String str, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

