package com.ku.base;

import com.ku.annotation.Remark;
import com.ku.util.Convert;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Remark("分页返回结果")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Page<T> {

    private int page;
    private int size;
    private long total;
    private int totalPages;
    private List<T> content;

    public static Page result(Object source) {
        Map<String, Object> middle = Convert.beanToMap(source);
        Page result = new Page();
        result.setContent((List<?>)middle.get("list"));
        result.setTotal(Double.valueOf(middle.get("total").toString()).intValue());
        result.setPage(Double.valueOf(middle.get("pageNum").toString()).intValue());
        result.setSize(Double.valueOf(middle.get("pageSize").toString()).intValue());
        result.setTotalPages(Double.valueOf(middle.get("pages").toString()).intValue());
        return result;
    }
}
