package com.ku.util;

import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.List;
public class ConvertUtil {

    public static <T> List<T> convert(List<?> source, Class<T> targetClass) {
        List<Object> targetList = new ArrayList<Object>();
        Operational.notNull(source,"Array source cannot be empty");
        source.forEach(e->{
            JSONObject entity = JSONObject.from(e);
            Object target = JSONObject.parseObject(entity.toString(),targetClass);
            targetList.add(target);
        });
        return (List<T>) targetList;
    }

    public static <T> T convert(Object source,Class<T> target){
        Operational.isNull(source,"Object source cannot be empty");
        return JSONObject.parseObject(JSONObject.from(source).toString(),target);
    }
}
