package com.ku.util;

import com.alibaba.fastjson.JSON;
import com.ku.annotation.Remark;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Convert {

    @Remark(value = "对象互转")
    public static  <T> T convert(Object source, Class<T> zclass) {
        String result = JSON.toJSONString(source);
        return JSON.parseObject(result,zclass);
    }

    @Remark(value = "数组互转")
    public static <T> List<T> convert(List<?> source, Class<T> zclass){
        List<T> result = new ArrayList<>();
        if(source.size()>0){
            source.forEach(e->{
                result.add(Convert.convert(e,zclass));
            });
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Remark(value = "对象转Map")
    public static Map<String, Object> beanToMap(Object object){
        return JSON.parseObject(JSON.toJSONString(object),Map.class);
    }

}
