package com.ku.util;

import com.ku.annotation.Remark;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {

	public final static String DATE_FORMAT = "yyyy-MM-dd";
	public final static String TIME_FORMAT = "yyyy-MM-dd hh:mm:ss";

	public static String format(Date date, String pattern) {
		DateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
		return sdf.format(date);
	}

	@Remark(value = "几天前")
	public static String before(Date d, int day) {
		Calendar now = Calendar.getInstance();
		now.setTime(d);
		now.set(Calendar.DATE, now.get(Calendar.DATE) - day);
		return format(now.getTime(), TIME_FORMAT);
	}
	@Remark(value = "几天后")
	public static String after(Date d, int day) {
		Calendar now = Calendar.getInstance();
		now.setTime(d);
		now.set(Calendar.DATE, now.get(Calendar.DATE) + day);
		return format(now.getTime(), TIME_FORMAT);
	}
	@Remark(value = "时间字符串转日期")
	public static Date toDate(String dateStr) {
		 DateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
	     Date date = new Date();  
		 try {
			 date =  sdf.parse(dateStr);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}
	
	public static String now() {
		return format(new Date(), TIME_FORMAT);
	}

}
