/*
 * Decompiled with CFR 0.152.
 */
package com.ku.util;

import com.ku.annotation.Remark;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd hh:mm:ss";

    public static String format(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
        return sdf.format(date);
    }

    @Remark(value="\u51e0\u5929\u524d")
    public static String before(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return DateUtil.format(now.getTime(), TIME_FORMAT);
    }

    @Remark(value="\u51e0\u5929\u540e")
    public static String after(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return DateUtil.format(now.getTime(), TIME_FORMAT);
    }

    @Remark(value="\u65f6\u95f4\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f")
    public static Date toDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
        Date date = new Date();
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String now() {
        return DateUtil.format(new Date(), TIME_FORMAT);
    }
}

