/*
 * Decompiled with CFR 0.152.
 */
package com.ku.util;

import com.ku.base.KeyValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumUtil {
    public static <T> Map<Object, String> toMap(Class<T> enumT, String ... methodNames) {
        HashMap<Object, String> enummap = new HashMap<Object, String>();
        if (!enumT.isEnum()) {
            return enummap;
        }
        T[] enums = enumT.getEnumConstants();
        if (enums == null || enums.length <= 0) {
            return enummap;
        }
        int count = methodNames.length;
        String valueMathod = "getValue";
        String desMathod = "getRemark";
        if (count >= 1 && !"".equals(methodNames[0])) {
            valueMathod = methodNames[0];
        }
        if (count == 2 && !"".equals(methodNames[1])) {
            desMathod = methodNames[1];
        }
        for (T tobj : enums) {
            try {
                Object resultValue = EnumUtil.getMethodValue(valueMathod, tobj, new Object[0]);
                if ("".equals(resultValue)) continue;
                Object resultDes = EnumUtil.getMethodValue(desMathod, tobj, new Object[0]);
                if ("".equals(resultDes)) {
                    resultDes = tobj;
                }
                enummap.put(resultValue, resultDes + "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return enummap;
    }

    private static <T> Object getMethodValue(String methodName, T obj, Object ... args) {
        Object resut = "";
        try {
            Method[] methods = obj.getClass().getMethods();
            if (methods.length <= 0) {
                return resut;
            }
            Method method = null;
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
                methodName = methods[i].getName();
                method = methods[i];
                break;
            }
            if (method == null) {
                return resut;
            }
            resut = method.invoke(obj, args);
            if (resut == null) {
                resut = "";
            }
            return resut;
        }
        catch (Exception e) {
            e.printStackTrace();
            return resut;
        }
    }

    public static <T> List<KeyValue> toList(Class<T> enumT, String ... methodNames) {
        Map<Object, String> map = EnumUtil.toMap(enumT, new String[0]);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        for (Object key : map.keySet()) {
            String value = key.toString();
            String label = map.get(key);
            values.add(new KeyValue(value, label));
        }
        return values;
    }
}

