/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunkesapps;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.runners.model.MultipleFailureException;

public class MultiErrorCheck {
    private ArrayList<Throwable> errors = new ArrayList();
    private ArrayList<Callable> callables = new ArrayList();

    public <T> void addCheck(T actual, Matcher matcher) {
        this.addCheck("", actual, matcher);
    }

    public <T> void addCheck(final String reason, final T actual, final Matcher matcher) {
        this.callables.add(new Callable(){

            public Object call() throws Exception {
                try {
                    MatcherAssert.assertThat((String)reason, (Object)actual, (Matcher)matcher);
                }
                catch (Throwable err) {
                    MultiErrorCheck.this.errors.add(err);
                }
                return null;
            }
        });
    }

    public void validateAllErrors() throws Throwable {
        this.callables.forEach(callable -> {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        MultipleFailureException.assertEmpty(this.errors);
    }
}

