/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest.orders;

import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.enums.Direction;
import io.github.mainstringargs.alpaca.enums.OrderStatus;
import io.github.mainstringargs.alpaca.rest.orders.OrdersRequestBuilder;
import java.time.LocalDateTime;

public class GetListOfOrdersRequestBuilder
extends OrdersRequestBuilder {
    public GetListOfOrdersRequestBuilder(String baseUrl) {
        super(baseUrl);
    }

    public GetListOfOrdersRequestBuilder status(OrderStatus status) {
        if (status != null) {
            super.appendURLParameter("status", status.getAPIName());
        }
        return this;
    }

    public GetListOfOrdersRequestBuilder limit(Integer limit) {
        if (limit != null) {
            super.appendURLParameter("limit", limit.toString());
        }
        return this;
    }

    public GetListOfOrdersRequestBuilder after(LocalDateTime after) {
        if (after != null) {
            super.appendURLParameter("after", Utilities.toDateTimeString(after));
        }
        return this;
    }

    public GetListOfOrdersRequestBuilder until(LocalDateTime until) {
        if (until != null) {
            super.appendURLParameter("until", Utilities.toDateTimeString(until));
        }
        return this;
    }

    public GetListOfOrdersRequestBuilder direction(Direction direction) {
        if (direction != null) {
            super.appendURLParameter("direction", direction.getAPIName());
        }
        return this;
    }
}

