/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.abstracts.websocket.client;

import io.github.mainstringargs.abstracts.websocket.client.WebsocketClient;
import io.github.mainstringargs.util.concurrency.ExecutorTracer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractWebsocketClientEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(AbstractWebsocketClientEndpoint.class);
    private WebsocketClient websocketClient;
    private final URI endpointURI;
    private final ExecutorService executorService;
    private Session userSession;
    private int retryAttempts = 0;

    public AbstractWebsocketClientEndpoint(WebsocketClient websocketClient, URI endpointURI, String messageThreadName) {
        this.websocketClient = websocketClient;
        this.endpointURI = endpointURI;
        this.executorService = ExecutorTracer.newSingleThreadExecutor(r -> new Thread(r, messageThreadName));
    }

    public void connect() throws DeploymentException, IOException {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        LOGGER.info("Connecting to " + this.endpointURI);
        container.connectToServer((Object)this, this.endpointURI);
    }

    public void disconnect() throws IOException {
        if (this.userSession != null) {
            this.userSession.close();
        }
    }

    protected void onOpen(Session userSession) {
        this.userSession = userSession;
        LOGGER.debug("onOpen " + userSession);
        LOGGER.info("Websocket opened");
        LOGGER.info("Authenticating...");
        this.websocketClient.sendAuthenticationMessage();
    }

    protected void onClose(Session userSession, CloseReason reason) {
        this.userSession = null;
        LOGGER.debug("onClose " + userSession);
        if (!reason.getCloseCode().equals(CloseReason.CloseCodes.NORMAL_CLOSURE)) {
            if (this.retryAttempts > 5) {
                LOGGER.error("More than 5 attempts to reconnect were made.");
                return;
            }
            LOGGER.info("Attempting a reconnect in 3 seconds.");
            ++this.retryAttempts;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            LOGGER.info("Reconnecting due to closure " + CloseReason.CloseCodes.getCloseCode((int)reason.getCloseCode().getCode()));
            try {
                this.connect();
            }
            catch (Exception e) {
                LOGGER.catching((Throwable)e);
            }
        } else {
            LOGGER.info("Websocket closed");
        }
    }

    protected void onMessage(String message) {
        this.executorService.execute(() -> this.websocketClient.handleWebsocketMessage(message));
    }

    public void sendMessage(String message) {
        LOGGER.debug("sendMessage " + message);
        this.userSession.getAsyncRemote().sendText(message);
    }

    public Session getUserSession() {
        return this.userSession;
    }
}

