/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.websocket.client;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.mainstringargs.abstracts.websocket.client.WebsocketClient;
import io.github.mainstringargs.abstracts.websocket.listener.StreamListener;
import io.github.mainstringargs.abstracts.websocket.message.StreamMessage;
import io.github.mainstringargs.abstracts.websocket.message.StreamMessageType;
import io.github.mainstringargs.alpaca.websocket.client.AlpacaWebsocketClientEndpoint;
import io.github.mainstringargs.alpaca.websocket.listener.AlpacaStreamListener;
import io.github.mainstringargs.alpaca.websocket.message.AlpacaStreamMessageType;
import io.github.mainstringargs.domain.alpaca.websocket.AlpacaStreamMessage;
import io.github.mainstringargs.domain.alpaca.websocket.account.AccountUpdateMessage;
import io.github.mainstringargs.domain.alpaca.websocket.authorization.AuthorizationMessage;
import io.github.mainstringargs.domain.alpaca.websocket.listening.ListeningMessage;
import io.github.mainstringargs.domain.alpaca.websocket.trade.TradeUpdateMessage;
import io.github.mainstringargs.util.gson.GsonUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaWebsocketClient
implements WebsocketClient {
    private static final Logger LOGGER = LogManager.getLogger(AlpacaWebsocketClient.class);
    private static final String STREAM_KEY = "stream";
    private String keyId;
    private String secret;
    private String baseAPIURL;
    private List<AlpacaStreamListener> listeners;
    private AlpacaWebsocketClientEndpoint alpacaWebsocketClientEndpoint;
    private boolean authenticated;

    public AlpacaWebsocketClient(String keyId, String secret, String baseAPIURL) {
        this.keyId = keyId;
        this.secret = secret;
        this.baseAPIURL = baseAPIURL.replace("https", "wss") + "/stream";
        this.listeners = new ArrayList<AlpacaStreamListener>();
    }

    @Override
    public void addListener(StreamListener streamListener) {
        Preconditions.checkState((boolean)(streamListener instanceof AlpacaStreamListener));
        if (this.listeners.isEmpty()) {
            this.connect();
        }
        this.listeners.add((AlpacaStreamListener)streamListener);
        this.submitStreamRequestUpdate();
    }

    @Override
    public void removeListener(StreamListener streamListener) {
        Preconditions.checkState((boolean)(streamListener instanceof AlpacaStreamListener));
        this.listeners.remove(streamListener);
        this.submitStreamRequestUpdate();
        if (this.listeners.isEmpty()) {
            this.disconnect();
        }
    }

    @Override
    public void connect() {
        LOGGER.info("Connecting...");
        try {
            this.alpacaWebsocketClientEndpoint = new AlpacaWebsocketClientEndpoint(this, new URI(this.baseAPIURL));
            this.alpacaWebsocketClientEndpoint.connect();
            LOGGER.info("Connected.");
        }
        catch (IOException | URISyntaxException | DeploymentException e) {
            LOGGER.throwing(e);
        }
    }

    @Override
    public void disconnect() {
        LOGGER.info("Disconnecting...");
        try {
            this.alpacaWebsocketClientEndpoint.getUserSession().close();
            LOGGER.info("Disconnected.");
        }
        catch (IOException e) {
            LOGGER.throwing((Throwable)e);
        }
    }

    @Override
    public void sendAuthenticationMessage() {
        JsonObject authRequest = new JsonObject();
        authRequest.addProperty("action", "authenticate");
        JsonObject payload = new JsonObject();
        payload.addProperty("key_id", this.keyId);
        payload.addProperty("secret_key", this.secret);
        authRequest.add("data", (JsonElement)payload);
        this.alpacaWebsocketClientEndpoint.sendMessage(authRequest.toString());
    }

    @Override
    public void handleWebsocketMessage(String message) {
        JsonElement messageJsonElement = GsonUtil.JSON_PARSER.parse(message);
        Preconditions.checkState((boolean)(messageJsonElement instanceof JsonObject));
        JsonObject messageJsonObject = messageJsonElement.getAsJsonObject();
        JsonElement streamJsonElement = messageJsonObject.get(STREAM_KEY);
        if (streamJsonElement instanceof JsonPrimitive) {
            try {
                AlpacaStreamMessageType alpacaStreamMessageType = (AlpacaStreamMessageType)GsonUtil.GSON.fromJson(streamJsonElement, AlpacaStreamMessageType.class);
                switch (alpacaStreamMessageType) {
                    case LISTENING: {
                        ListeningMessage listeningMessage = (ListeningMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, ListeningMessage.class);
                        this.sendStreamMessageToListeners(alpacaStreamMessageType, listeningMessage);
                        LOGGER.debug((Object)listeningMessage);
                        break;
                    }
                    case AUTHORIZATION: {
                        AuthorizationMessage authorizationMessage = (AuthorizationMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, AuthorizationMessage.class);
                        this.sendStreamMessageToListeners(alpacaStreamMessageType, authorizationMessage);
                        this.authenticated = this.isAuthorizationMessageSuccess(authorizationMessage);
                        LOGGER.debug((Object)authorizationMessage);
                        break;
                    }
                    case TRADE_UPDATES: {
                        this.sendStreamMessageToListeners(alpacaStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, TradeUpdateMessage.class));
                        break;
                    }
                    case ACCOUNT_UPDATES: {
                        this.sendStreamMessageToListeners(alpacaStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, AccountUpdateMessage.class));
                        break;
                    }
                    default: {
                        LOGGER.error("Unhandled stream type: " + alpacaStreamMessageType);
                        break;
                    }
                }
            }
            catch (JsonSyntaxException e) {
                LOGGER.throwing((Throwable)e);
            }
        } else {
            LOGGER.error("Unknown stream message: " + messageJsonObject);
        }
    }

    @Override
    public void sendStreamMessageToListeners(StreamMessageType streamMessageType, StreamMessage streamMessage) {
        Preconditions.checkState((boolean)(streamMessageType instanceof AlpacaStreamMessageType));
        Preconditions.checkState((boolean)(streamMessage instanceof AlpacaStreamMessage));
        AlpacaStreamMessageType alpacaStreamMessageType = (AlpacaStreamMessageType)streamMessageType;
        AlpacaStreamMessage alpacaStreamMessage = (AlpacaStreamMessage)streamMessage;
        for (AlpacaStreamListener alpacaStreamListener : this.listeners) {
            if (alpacaStreamListener.getStreamMessageTypes() != null && !alpacaStreamListener.getStreamMessageTypes().isEmpty() && !alpacaStreamListener.getStreamMessageTypes().contains(alpacaStreamMessageType)) continue;
            alpacaStreamListener.onStreamUpdate(alpacaStreamMessageType, alpacaStreamMessage);
        }
    }

    @Override
    public boolean isConnected() {
        return this.alpacaWebsocketClientEndpoint.getUserSession().isOpen();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    private boolean isAuthorizationMessageSuccess(AuthorizationMessage authorizationMessage) {
        return authorizationMessage.getData().getStatus().equalsIgnoreCase("authorized") && authorizationMessage.getData().getAction().equalsIgnoreCase("authenticate");
    }

    private void submitStreamRequestUpdate() {
        JsonObject streamRequestJsonObject = new JsonObject();
        streamRequestJsonObject.addProperty("action", "listen");
        JsonArray streamsJsonArray = new JsonArray();
        this.getRegisteredMessageTypes().forEach(alpacaStreamMessageType -> streamsJsonArray.add(alpacaStreamMessageType.getAPIName()));
        JsonObject dataJsonObject = new JsonObject();
        dataJsonObject.add("streams", (JsonElement)streamsJsonArray);
        streamRequestJsonObject.add("data", (JsonElement)dataJsonObject);
        this.alpacaWebsocketClientEndpoint.sendMessage(streamRequestJsonObject.toString());
        LOGGER.info("Requested subscriptions to update to " + streamsJsonArray);
    }

    public Set<AlpacaStreamMessageType> getRegisteredMessageTypes() {
        HashSet<AlpacaStreamMessageType> registeredStreamMessageTypes = new HashSet<AlpacaStreamMessageType>();
        for (AlpacaStreamListener alpacaStreamListener : this.listeners) {
            Set<AlpacaStreamMessageType> alpacaStreamMessageTypes = alpacaStreamListener.getStreamMessageTypes();
            HashSet streamMessageTypesToAdd = alpacaStreamMessageTypes == null ? new HashSet() : alpacaStreamMessageTypes.stream().filter(AlpacaStreamMessageType::isAPISubscribable).collect(Collectors.toSet());
            registeredStreamMessageTypes.addAll(streamMessageTypesToAdd);
        }
        return registeredStreamMessageTypes;
    }
}

