/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon;

import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import com.mashape.unirest.http.HttpResponse;
import io.github.mainstringargs.domain.polygon.aggregates.AggregatesResponse;
import io.github.mainstringargs.domain.polygon.conditionsmapping.ConditionsMapping;
import io.github.mainstringargs.domain.polygon.dailyopenclose.DailyOpenCloseResponse;
import io.github.mainstringargs.domain.polygon.exchanges.Exchange;
import io.github.mainstringargs.domain.polygon.groupeddaily.GroupedDailyResponse;
import io.github.mainstringargs.domain.polygon.historicquotes.HistoricQuotesResponse;
import io.github.mainstringargs.domain.polygon.historictrades.HistoricTradesResponse;
import io.github.mainstringargs.domain.polygon.lastquote.LastQuoteResponse;
import io.github.mainstringargs.domain.polygon.lasttrade.LastTradeResponse;
import io.github.mainstringargs.domain.polygon.locales.LocalesResponse;
import io.github.mainstringargs.domain.polygon.marketholidays.MarketHoliday;
import io.github.mainstringargs.domain.polygon.markets.MarketsResponse;
import io.github.mainstringargs.domain.polygon.marketstatus.MarketStatus;
import io.github.mainstringargs.domain.polygon.previousclose.PreviousCloseResponse;
import io.github.mainstringargs.domain.polygon.snapshot.SnapshotAllTickersResponse;
import io.github.mainstringargs.domain.polygon.snapshot.SnapshotGainersLosersResponse;
import io.github.mainstringargs.domain.polygon.snapshot.SnapshotSingleTickerResponse;
import io.github.mainstringargs.domain.polygon.snapshot.SnapshotTickerBook;
import io.github.mainstringargs.domain.polygon.stockdividends.StockDividendsResponse;
import io.github.mainstringargs.domain.polygon.stockfinancials.StockFinancialsResponse;
import io.github.mainstringargs.domain.polygon.stocksplits.StockSplitsResponse;
import io.github.mainstringargs.domain.polygon.tickerdetails.TickerDetails;
import io.github.mainstringargs.domain.polygon.tickernews.TickerNews;
import io.github.mainstringargs.domain.polygon.tickers.TickersResponse;
import io.github.mainstringargs.domain.polygon.tickertypes.TickerTypes;
import io.github.mainstringargs.polygon.enums.ConditionMappingsType;
import io.github.mainstringargs.polygon.enums.FinancialReportType;
import io.github.mainstringargs.polygon.enums.FinancialSort;
import io.github.mainstringargs.polygon.enums.GainersLosersDirection;
import io.github.mainstringargs.polygon.enums.Market;
import io.github.mainstringargs.polygon.enums.StockType;
import io.github.mainstringargs.polygon.enums.TickerSort;
import io.github.mainstringargs.polygon.enums.Timespan;
import io.github.mainstringargs.polygon.properties.PolygonProperties;
import io.github.mainstringargs.polygon.rest.PolygonRequest;
import io.github.mainstringargs.polygon.rest.PolygonRequestBuilder;
import io.github.mainstringargs.polygon.rest.exception.PolygonAPIRequestException;
import io.github.mainstringargs.polygon.websocket.client.PolygonWebsocketClient;
import io.github.mainstringargs.polygon.websocket.listener.PolygonStreamListener;
import io.github.mainstringargs.util.time.TimeUtil;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolygonAPI {
    private static Logger LOGGER = LogManager.getLogger(PolygonAPI.class);
    private final PolygonWebsocketClient polygonWebsocketClient;
    private final PolygonRequest polygonRequest;
    private String baseAPIURL;
    private String websocketURL;
    private String keyID;

    public PolygonAPI() {
        this(PolygonProperties.KEY_ID_VALUE);
        LOGGER.debug(PolygonProperties.staticToString());
    }

    public PolygonAPI(String keyId) {
        this(PolygonProperties.BASE_API_URL_VALUE, PolygonProperties.POLYGON_WEB_SOCKET_SERVER_URL_VALUE, keyId);
    }

    public PolygonAPI(String baseAPIURL, String websocketURL, String keyID) {
        this.baseAPIURL = baseAPIURL;
        this.websocketURL = websocketURL;
        this.keyID = keyID;
        this.polygonRequest = new PolygonRequest(keyID);
        this.polygonWebsocketClient = new PolygonWebsocketClient(keyID, websocketURL);
        LOGGER.debug(this.toString());
    }

    public TickersResponse getTickers(TickerSort tickerSort, StockType stockType, Market market, String locale, String search, Integer perpage, Integer page, Boolean active) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "tickers");
        if (tickerSort != null) {
            builder.appendURLParameter("sort", tickerSort.getAPIName());
        }
        if (stockType != null) {
            builder.appendURLParameter("type", stockType.getAPIName());
        }
        if (market != null) {
            builder.appendURLParameter("market", market.getAPIName());
        }
        if (locale != null) {
            builder.appendURLParameter("locale", locale);
        }
        if (search != null) {
            builder.appendURLParameter("search", search);
        }
        if (perpage != null) {
            builder.appendURLParameter("perpage", String.valueOf(perpage));
        }
        if (page != null) {
            builder.appendURLParameter("page", String.valueOf(page));
        }
        if (active != null) {
            builder.appendURLParameter("active", String.valueOf(active));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (TickersResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)TickersResponse.class));
    }

    public TickerTypes getTickerTypes() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "types");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (TickerTypes)this.polygonRequest.getResponseObject(response, (Type)((Object)TickersResponse.class));
    }

    public TickerDetails getTickerDetails(String symbol) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "meta", "symbols", symbol, "company");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (TickerDetails)this.polygonRequest.getResponseObject(response, (Type)((Object)TickerDetails.class));
    }

    public ArrayList<TickerNews> getTickerNews(String symbol, Integer perpage, Integer page) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "meta", "symbols", symbol, "news");
        if (perpage != null) {
            builder.appendURLParameter("perpage", String.valueOf(perpage));
        }
        if (page != null) {
            builder.appendURLParameter("page", String.valueOf(page));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        Type listType = new TypeToken<ArrayList<TickerNews>>(){}.getType();
        return (ArrayList)this.polygonRequest.getResponseObject(response, listType);
    }

    public MarketsResponse getMarkets() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "markets");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (MarketsResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)MarketsResponse.class));
    }

    public LocalesResponse getLocales() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "locales");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (LocalesResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)LocalesResponse.class));
    }

    public StockSplitsResponse getStockSplits(String symbol) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "splits", symbol);
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (StockSplitsResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)StockSplitsResponse.class));
    }

    public StockDividendsResponse getStockDividends(String symbol) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "dividends", symbol);
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (StockDividendsResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)StockDividendsResponse.class));
    }

    public StockFinancialsResponse getStockFinancials(String symbol, Integer limit, FinancialReportType financialReportType, FinancialSort financialSort) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "reference", "financials", symbol);
        if (limit != null) {
            builder.appendURLParameter("limit", String.valueOf(limit));
        }
        if (financialReportType != null) {
            builder.appendURLParameter("type", financialReportType.getAPIName());
        }
        if (financialSort != null) {
            builder.appendURLParameter("sort", financialSort.getAPIName());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (StockFinancialsResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)StockFinancialsResponse.class));
    }

    public MarketStatus getMarketStatus() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "marketstatus", "now");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (MarketStatus)this.polygonRequest.getResponseObject(response, (Type)((Object)MarketStatus.class));
    }

    public ArrayList<MarketHoliday> getMarketHolidays() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "marketstatus", "upcoming");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        Type listType = new TypeToken<ArrayList<MarketHoliday>>(){}.getType();
        return (ArrayList)this.polygonRequest.getResponseObject(response, listType);
    }

    public ArrayList<Exchange> getExchanges() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "meta", "exchanges");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        Type listType = new TypeToken<ArrayList<Exchange>>(){}.getType();
        return (ArrayList)this.polygonRequest.getResponseObject(response, listType);
    }

    public HistoricTradesResponse getHistoricTrades(String ticker, LocalDate date, Long timestamp, Long timestampLimit, Boolean reverse, Integer limit) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)ticker);
        Preconditions.checkNotNull((Object)date);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "ticks", "stocks", "trades", ticker, TimeUtil.toDateString(date));
        if (timestamp != null) {
            builder.appendURLParameter("timestamp", String.valueOf(timestamp));
        }
        if (timestampLimit != null) {
            builder.appendURLParameter("timestampLimit", String.valueOf(timestampLimit));
        }
        if (reverse != null) {
            builder.appendURLParameter("reverse", String.valueOf(reverse));
        }
        if (limit != null) {
            builder.appendURLParameter("limit", String.valueOf(limit));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (HistoricTradesResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)HistoricTradesResponse.class));
    }

    public HistoricQuotesResponse getHistoricQuotes(String ticker, LocalDate date, Long timestamp, Long timestampLimit, Boolean reverse, Integer limit) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)ticker);
        Preconditions.checkNotNull((Object)date);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "ticks", "stocks", "nbbo", ticker, TimeUtil.toDateString(date));
        if (timestamp != null) {
            builder.appendURLParameter("timestamp", String.valueOf(timestamp));
        }
        if (timestampLimit != null) {
            builder.appendURLParameter("timestampLimit", String.valueOf(timestampLimit));
        }
        if (reverse != null) {
            builder.appendURLParameter("reverse", String.valueOf(reverse));
        }
        if (limit != null) {
            builder.appendURLParameter("limit", String.valueOf(limit));
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (HistoricQuotesResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)HistoricQuotesResponse.class));
    }

    public LastTradeResponse getLastTrade(String symbol) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "last", "stocks", symbol);
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (LastTradeResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)LastTradeResponse.class));
    }

    public LastQuoteResponse getLastQuote(String symbol) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "last_quote", "stocks", symbol);
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (LastQuoteResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)LastQuoteResponse.class));
    }

    public DailyOpenCloseResponse getDailyOpenClose(String symbol, LocalDate date) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)symbol);
        Preconditions.checkNotNull((Object)date);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "open-close", symbol, TimeUtil.toDateString(date));
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (DailyOpenCloseResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)DailyOpenCloseResponse.class));
    }

    public ConditionsMapping getConditionsMapping(ConditionMappingsType conditionMappingsType) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)conditionMappingsType);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v1", "meta", "conditions", conditionMappingsType.getAPIName());
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (ConditionsMapping)this.polygonRequest.getResponseObject(response, (Type)((Object)ConditionsMapping.class));
    }

    public SnapshotAllTickersResponse getSnapshotAllTickers() throws PolygonAPIRequestException {
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "snapshot", "locale", "us", "markets", "stocks", "tickers");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (SnapshotAllTickersResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)SnapshotAllTickersResponse.class));
    }

    public SnapshotSingleTickerResponse getSnapshotSingleTicker(String ticker) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)ticker);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "snapshot", "locale", "us", "markets", "stocks", "tickers", ticker);
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (SnapshotSingleTickerResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)SnapshotSingleTickerResponse.class));
    }

    public SnapshotGainersLosersResponse getSnapshotsGainersLosers(GainersLosersDirection gainersLosersDirection) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)gainersLosersDirection);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "snapshot", "locale", "us", "markets", "stocks", gainersLosersDirection.getAPIName());
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (SnapshotGainersLosersResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)SnapshotGainersLosersResponse.class));
    }

    public SnapshotTickerBook getSnapshotTickerBook(String locale, Market market, String ticker) throws PolygonAPIRequestException {
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull((Object)market);
        Preconditions.checkNotNull((Object)ticker);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "snapshot", "locale", locale, "markets", market.getAPIName(), "tickers", ticker, "book");
        HttpResponse<InputStream> response = this.polygonRequest.invokeGet(builder);
        if (response.getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (SnapshotTickerBook)this.polygonRequest.getResponseObject(response, (Type)((Object)SnapshotTickerBook.class));
    }

    public PreviousCloseResponse getPreviousClose(String ticker, Boolean unadjusted) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)ticker);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "aggs", "ticker", ticker, "prev");
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (PreviousCloseResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)PreviousCloseResponse.class));
    }

    public AggregatesResponse getAggregates(String ticker, Integer multiplier, Timespan timeSpan, LocalDate fromDate, LocalDate toDate, Boolean unadjusted) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)ticker);
        Preconditions.checkNotNull((Object)timeSpan);
        Preconditions.checkNotNull((Object)fromDate);
        Preconditions.checkNotNull((Object)toDate);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "aggs", "ticker", ticker, "range", Integer.toString(multiplier == null ? 1 : multiplier), timeSpan.getAPIName(), TimeUtil.toDateString(fromDate), TimeUtil.toDateString(toDate));
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (AggregatesResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)AggregatesResponse.class));
    }

    public GroupedDailyResponse getGroupedDaily(String locale, Market market, LocalDate date, Boolean unadjusted) throws PolygonAPIRequestException {
        HttpResponse<InputStream> response;
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull((Object)market);
        Preconditions.checkNotNull((Object)date);
        PolygonRequestBuilder builder = new PolygonRequestBuilder(this.baseAPIURL, "v2", "aggs", "grouped", "locale", locale, "market", market.getAPIName(), TimeUtil.toDateString(date));
        if (unadjusted != null) {
            builder.appendURLParameter("unadjusted", unadjusted.toString());
        }
        if ((response = this.polygonRequest.invokeGet(builder)).getStatus() != 200) {
            throw new PolygonAPIRequestException(response);
        }
        return (GroupedDailyResponse)this.polygonRequest.getResponseObject(response, (Type)((Object)GroupedDailyResponse.class));
    }

    public void addPolygonStreamListener(PolygonStreamListener streamListener) {
        this.polygonWebsocketClient.addListener(streamListener);
    }

    public void removePolygonStreamListener(PolygonStreamListener streamListener) {
        this.polygonWebsocketClient.removeListener(streamListener);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("baseAPIURL = " + this.baseAPIURL).add("keyID = " + this.keyID).add("websocketURL = " + this.websocketURL).toString();
    }
}

