/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.util.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import io.github.mainstringargs.util.gson.ZonedDateTimeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsonUtil {
    private static final Logger LOGGER = LogManager.getLogger(GsonUtil.class);
    private static final HashMap<Class, ArrayList<SerializedName>> CLASS_ANNOTATION_CACHE = new HashMap();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).enableComplexMapKeySerialization().setLenient().create();
    public static final JsonParser JSON_PARSER = new JsonParser();

    public static boolean doesGsonPOJOMatch(Class jsonPOJOClass, JsonObject jsonObject) {
        ArrayList<SerializedName> gsonSerializedNameAnnotations = GsonUtil.getGsonSerializedNameAnnotations(jsonPOJOClass);
        Set jsonObjectKeys = jsonObject.keySet();
        ArrayList classKeys = new ArrayList();
        gsonSerializedNameAnnotations.forEach(c -> classKeys.add(c.value()));
        for (String key : jsonObjectKeys) {
            if (classKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private static synchronized ArrayList<SerializedName> getGsonSerializedNameAnnotations(Class theClass) {
        if (CLASS_ANNOTATION_CACHE.containsKey(theClass)) {
            return CLASS_ANNOTATION_CACHE.get(theClass);
        }
        LOGGER.debug("Caching Gson @SerializedName annotations for " + theClass.getName());
        ArrayList<SerializedName> serializedNameAnnotations = new ArrayList<SerializedName>();
        Class currentClass = theClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SerializedName)) continue;
                    serializedNameAnnotations.add((SerializedName)annotation);
                }
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        CLASS_ANNOTATION_CACHE.put(theClass, serializedNameAnnotations);
        return serializedNameAnnotations;
    }
}

