/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.abstracts.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRequestBuilder {
    private static final String URL_SEPARATOR = "/";
    private final List<String> appendedEndpoints = new ArrayList<String>();
    private final Map<String, String> urlParameters = new LinkedHashMap<String, String>();
    private final JsonObject bodyJsonObject = new JsonObject();
    private final String baseUrl;
    private String customBody;

    public AbstractRequestBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void appendEndpoint(String endpoint) {
        if (endpoint != null) {
            this.appendedEndpoints.add(endpoint);
        }
    }

    public void appendURLParameter(String urlKey, String urlValue) {
        if (urlValue != null) {
            this.urlParameters.put(urlKey, urlValue);
        }
    }

    public void appendJSONBodyProperty(String bodyKey, String bodyValue) {
        if (bodyValue != null) {
            this.bodyJsonObject.addProperty(bodyKey, bodyValue);
        }
    }

    public void appendJSONBodyJSONProperty(String bodyKey, JsonElement bodyValue) {
        if (bodyValue != null) {
            this.bodyJsonObject.add(bodyKey, bodyValue);
        }
    }

    public String getURL() {
        StringBuilder builder = new StringBuilder(this.baseUrl);
        for (String string : this.appendedEndpoints) {
            builder.append(URL_SEPARATOR);
            builder.append(string);
        }
        if (!this.urlParameters.isEmpty()) {
            builder.append('?');
            for (Map.Entry entry : this.urlParameters.entrySet()) {
                builder.append(((String)entry.getKey()).trim());
                builder.append('=');
                builder.append(((String)entry.getValue()).trim());
                builder.append('&');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public String getBody() {
        if (this.customBody != null) {
            return this.customBody;
        }
        if (this.bodyJsonObject.size() > 0) {
            return this.bodyJsonObject.toString();
        }
        return null;
    }

    public void setCustomBody(String customBody) {
        this.customBody = customBody;
    }
}

