/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.abstracts.rest.exception;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mashape.unirest.http.HttpResponse;
import io.github.mainstringargs.util.gson.GsonUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public abstract class AbstractAPIRequestException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static final String CODE_KEY = "code";
    protected static final String MESSAGE_KEY = "message";
    protected final String apiName;
    protected HttpResponse<InputStream> httpResponse;
    protected int requestStatusCode;
    protected String requestStatusText;
    protected int apiResponseCode = -1;
    protected String apiResponseMessage;

    public AbstractAPIRequestException(String apiName, HttpResponse<InputStream> httpResponse) {
        this.apiName = apiName;
        this.httpResponse = httpResponse;
        this.requestStatusCode = httpResponse.getStatus();
        this.requestStatusText = httpResponse.getStatusText();
    }

    protected abstract void parseAPIExceptionMessage();

    protected void parseStandardAPIExceptionResponse() {
        JsonElement responseJsonElement = GsonUtil.JSON_PARSER.parse((Reader)new InputStreamReader((InputStream)this.httpResponse.getBody()));
        if (responseJsonElement instanceof JsonObject) {
            JsonObject responseJsonObject = (JsonObject)responseJsonElement;
            if (responseJsonObject.has(CODE_KEY)) {
                this.apiResponseCode = responseJsonObject.get(CODE_KEY).getAsInt();
            }
            if (responseJsonObject.has(MESSAGE_KEY)) {
                this.apiResponseMessage = responseJsonObject.get(MESSAGE_KEY).getAsString();
            }
        }
        if (this.apiResponseMessage == null) {
            this.apiResponseMessage = responseJsonElement.toString();
        }
    }

    @Override
    public String getMessage() {
        this.parseAPIExceptionMessage();
        StringBuilder messageBuilder = new StringBuilder(this.apiName).append(" API Request Exception! : ");
        messageBuilder.append("Status Code = ").append(this.requestStatusCode);
        messageBuilder.append(", Status Text = \"").append(this.requestStatusText).append("\"");
        if (this.apiResponseCode != -1) {
            messageBuilder.append(", API Response Code = ").append(this.apiResponseCode);
        }
        if (this.apiResponseMessage != null) {
            messageBuilder.append(", API Response Message = \"").append(this.apiResponseMessage).append("\"");
        }
        return messageBuilder.toString();
    }

    public int getRequestStatusCode() {
        return this.requestStatusCode;
    }

    public String getRequestStatusText() {
        return this.requestStatusText;
    }

    public int getAPIResponseCode() {
        return this.apiResponseCode;
    }

    public String getAPIResponseMessage() {
        return this.apiResponseMessage;
    }
}

