/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.websocket.client;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.mainstringargs.abstracts.websocket.client.WebsocketClient;
import io.github.mainstringargs.abstracts.websocket.listener.StreamListener;
import io.github.mainstringargs.abstracts.websocket.message.StreamMessage;
import io.github.mainstringargs.abstracts.websocket.message.StreamMessageType;
import io.github.mainstringargs.domain.polygon.websocket.PolygonStreamMessage;
import io.github.mainstringargs.domain.polygon.websocket.aggregate.AggregatePerMinuteMessage;
import io.github.mainstringargs.domain.polygon.websocket.aggregate.AggregatePerSecondMessage;
import io.github.mainstringargs.domain.polygon.websocket.quote.QuoteMessage;
import io.github.mainstringargs.domain.polygon.websocket.status.StatusMessage;
import io.github.mainstringargs.domain.polygon.websocket.trade.TradeMessage;
import io.github.mainstringargs.polygon.websocket.client.PolygonWebsocketClientEndpoint;
import io.github.mainstringargs.polygon.websocket.listener.PolygonStreamListener;
import io.github.mainstringargs.polygon.websocket.message.PolygonStreamMessageType;
import io.github.mainstringargs.util.gson.GsonUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolygonWebsocketClient
implements WebsocketClient {
    private static final Logger LOGGER = LogManager.getLogger(PolygonWebsocketClient.class);
    private static final String ALL_TICKERS = "*";
    private static final String EVENT_TYPE_KEY = "ev";
    private String keyId;
    private String websocketURL;
    private List<PolygonStreamListener> listeners;
    private PolygonWebsocketClientEndpoint polygonWebsocketClientEndpoint;
    private boolean authenticated;

    public PolygonWebsocketClient(String keyId, String websocketURL) {
        this.keyId = keyId;
        this.websocketURL = websocketURL;
        this.listeners = new ArrayList<PolygonStreamListener>();
    }

    @Override
    public void addListener(StreamListener listener) {
        Preconditions.checkState((boolean)(listener instanceof PolygonStreamListener));
        if (this.listeners.isEmpty()) {
            this.connect();
        }
        this.listeners.add((PolygonStreamListener)listener);
        this.submitStreamRequest(PolygonStreamAction.SUBSCRIBE, (PolygonStreamListener)listener);
    }

    @Override
    public void removeListener(StreamListener listener) {
        Preconditions.checkState((boolean)(listener instanceof PolygonStreamListener));
        this.listeners.remove(listener);
        this.submitStreamRequest(PolygonStreamAction.UNSUBSCRIBE, (PolygonStreamListener)listener);
        if (this.listeners.isEmpty()) {
            this.disconnect();
        }
    }

    @Override
    public void connect() {
        LOGGER.info("Connecting...");
        try {
            this.polygonWebsocketClientEndpoint = new PolygonWebsocketClientEndpoint(this, new URI(this.websocketURL));
            this.polygonWebsocketClientEndpoint.connect();
            LOGGER.info("Connected.");
        }
        catch (IOException | URISyntaxException | DeploymentException e) {
            LOGGER.throwing(e);
        }
    }

    @Override
    public void disconnect() {
        LOGGER.info("Disconnecting...");
        try {
            this.polygonWebsocketClientEndpoint.getUserSession().close();
            LOGGER.info("Disconnected.");
        }
        catch (IOException e) {
            LOGGER.throwing((Throwable)e);
        }
    }

    @Override
    public void sendAuthenticationMessage() {
        JsonObject authRequest = new JsonObject();
        authRequest.addProperty("action", "auth");
        authRequest.addProperty("params", this.keyId);
        this.polygonWebsocketClientEndpoint.sendMessage(authRequest.toString());
    }

    @Override
    public void handleWebsocketMessage(String message) {
        JsonElement messageJsonElement = GsonUtil.JSON_PARSER.parse(message);
        Preconditions.checkState((boolean)(messageJsonElement instanceof JsonArray));
        for (JsonElement jsonElement : messageJsonElement.getAsJsonArray()) {
            JsonObject messageJsonObject = jsonElement.getAsJsonObject();
            JsonElement eventTypeJsonElement = messageJsonObject.get(EVENT_TYPE_KEY);
            if (eventTypeJsonElement instanceof JsonPrimitive) {
                try {
                    PolygonStreamMessageType polygonStreamMessageType = (PolygonStreamMessageType)GsonUtil.GSON.fromJson(eventTypeJsonElement, PolygonStreamMessageType.class);
                    switch (polygonStreamMessageType) {
                        case STATUS: {
                            StatusMessage statusMessage = (StatusMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, StatusMessage.class);
                            this.sendStreamMessageToListeners(polygonStreamMessageType, statusMessage);
                            this.authenticated = this.isAuthenticatedStatusMessage(statusMessage);
                            LOGGER.debug((Object)statusMessage);
                            break;
                        }
                        case TRADE: {
                            this.sendStreamMessageToListeners(polygonStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, TradeMessage.class));
                            break;
                        }
                        case QUOTE: {
                            this.sendStreamMessageToListeners(polygonStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, QuoteMessage.class));
                            break;
                        }
                        case AGGREGATE_PER_SECOND: {
                            this.sendStreamMessageToListeners(polygonStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, AggregatePerSecondMessage.class));
                            break;
                        }
                        case AGGREGATE_PER_MINUTE: {
                            this.sendStreamMessageToListeners(polygonStreamMessageType, (StreamMessage)GsonUtil.GSON.fromJson((JsonElement)messageJsonObject, AggregatePerMinuteMessage.class));
                            break;
                        }
                        default: {
                            LOGGER.error("Unknown stream object: " + messageJsonObject);
                            break;
                        }
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.throwing((Throwable)e);
                }
                continue;
            }
            LOGGER.error("Unknown stream message: " + messageJsonObject);
        }
    }

    @Override
    public void sendStreamMessageToListeners(StreamMessageType streamMessageType, StreamMessage streamMessage) {
        Preconditions.checkState((boolean)(streamMessageType instanceof PolygonStreamMessageType));
        Preconditions.checkState((boolean)(streamMessage instanceof PolygonStreamMessage));
        PolygonStreamMessageType polygonStreamMessageType = (PolygonStreamMessageType)streamMessageType;
        PolygonStreamMessage polygonStreamMessage = (PolygonStreamMessage)streamMessage;
        for (PolygonStreamListener streamListener : this.listeners) {
            boolean sendToStreamListener = false;
            if (streamListener.getStockChannels().containsKey(polygonStreamMessage.getSym())) {
                if (streamListener.getStockChannels().get(polygonStreamMessage.getSym()).contains(polygonStreamMessageType)) {
                    sendToStreamListener = true;
                }
            } else if (streamListener.getStockChannels().containsKey(ALL_TICKERS) && streamListener.getStockChannels().get(ALL_TICKERS).contains(polygonStreamMessageType)) {
                sendToStreamListener = true;
            }
            if (!sendToStreamListener) continue;
            streamListener.onStreamUpdate(polygonStreamMessageType, polygonStreamMessage);
        }
    }

    @Override
    public boolean isConnected() {
        return this.polygonWebsocketClientEndpoint.getUserSession().isOpen();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    private boolean isAuthenticatedStatusMessage(StatusMessage statusMessage) {
        return statusMessage.getStatus().equalsIgnoreCase("success") && statusMessage.getMessage().equalsIgnoreCase("authenticated");
    }

    private void submitStreamRequest(PolygonStreamAction polygonStreamAction, PolygonStreamListener newListener) {
        Preconditions.checkNotNull((Object)((Object)polygonStreamAction));
        Preconditions.checkNotNull((Object)newListener);
        ArrayList<String> actionTickerList = new ArrayList<String>();
        Map<String, Set<PolygonStreamMessageType>> registeredTickerChannels = this.getRegisteredTickerChannels(newListener);
        Map<String, Set<PolygonStreamMessageType>> newListenerTickerChannels = newListener.getStockChannels();
        for (String ticker : newListenerTickerChannels.keySet()) {
            Set<PolygonStreamMessageType> registeredChannels = registeredTickerChannels.get(ticker);
            Set<PolygonStreamMessageType> newListenerChannelTypes = newListenerTickerChannels.get(ticker);
            if (registeredTickerChannels.containsKey(ticker)) {
                for (PolygonStreamMessageType listenerChannelType : newListenerChannelTypes) {
                    if (!listenerChannelType.isAPISubscribable()) continue;
                    boolean isTickerChannelRegistered = registeredChannels.contains(listenerChannelType);
                    String formattedWebsocketTicker = this.formatWebsocketTicker(listenerChannelType, ticker);
                    if (isTickerChannelRegistered) {
                        if (polygonStreamAction == PolygonStreamAction.UNSUBSCRIBE) {
                            LOGGER.warn("Cannot unsubscribe from " + ticker + " for channel " + listenerChannelType.name() + " because it is being used by another stream listener!");
                            continue;
                        }
                        if (polygonStreamAction != PolygonStreamAction.SUBSCRIBE) continue;
                        LOGGER.warn("Already subscribed to " + ticker + " for channel " + listenerChannelType.name() + "!");
                        continue;
                    }
                    actionTickerList.add(formattedWebsocketTicker);
                    if (polygonStreamAction == PolygonStreamAction.UNSUBSCRIBE) {
                        LOGGER.info("Unsubscribing from " + formattedWebsocketTicker);
                        continue;
                    }
                    if (polygonStreamAction != PolygonStreamAction.SUBSCRIBE) continue;
                    LOGGER.info("Subscribing to " + formattedWebsocketTicker);
                }
                continue;
            }
            for (PolygonStreamMessageType listenerChannelType : newListenerChannelTypes) {
                if (!listenerChannelType.isAPISubscribable()) continue;
                String formattedWebsocketTicker = this.formatWebsocketTicker(listenerChannelType, ticker);
                actionTickerList.add(formattedWebsocketTicker);
                if (polygonStreamAction == PolygonStreamAction.UNSUBSCRIBE) {
                    LOGGER.info("Unsubscribing from " + formattedWebsocketTicker);
                    continue;
                }
                if (polygonStreamAction != PolygonStreamAction.SUBSCRIBE) continue;
                LOGGER.info("Subscribing to " + formattedWebsocketTicker);
            }
        }
        if (actionTickerList.isEmpty()) {
            LOGGER.info("Did not change any channel listeners");
        } else {
            StringJoiner commaActionTickers = new StringJoiner(",");
            actionTickerList.forEach(commaActionTickers::add);
            JsonObject actionJsonObject = new JsonObject();
            actionJsonObject.addProperty("action", polygonStreamAction.getAPIName());
            actionJsonObject.addProperty("params", commaActionTickers.toString());
            this.polygonWebsocketClientEndpoint.sendMessage(actionJsonObject.toString());
            LOGGER.info("Requested subscriptions to update to " + this.getRegisteredTickerChannels(null));
        }
    }

    private String formatWebsocketTicker(PolygonStreamMessageType polygonStreamMessageType, String ticker) {
        return polygonStreamMessageType.getAPIName() + "." + ticker;
    }

    private Map<String, Set<PolygonStreamMessageType>> getRegisteredTickerChannels(PolygonStreamListener exclude) {
        HashMap<String, Set<PolygonStreamMessageType>> registeredTickerChannels = new HashMap<String, Set<PolygonStreamMessageType>>();
        for (PolygonStreamListener streamListener : this.listeners) {
            if (streamListener.equals(exclude)) continue;
            Map<String, Set<PolygonStreamMessageType>> stockChannelTypes = streamListener.getStockChannels();
            for (String ticker : stockChannelTypes.keySet()) {
                HashSet subscribableStreamMessageTypes;
                Set<PolygonStreamMessageType> streamMessageTypes = stockChannelTypes.get(ticker);
                Set<Object> set = subscribableStreamMessageTypes = streamMessageTypes == null ? new HashSet() : streamMessageTypes.stream().filter(PolygonStreamMessageType::isAPISubscribable).collect(Collectors.toSet());
                if (!registeredTickerChannels.containsKey(ticker)) {
                    registeredTickerChannels.put(ticker, subscribableStreamMessageTypes);
                    continue;
                }
                registeredTickerChannels.get(ticker).addAll(subscribableStreamMessageTypes);
            }
        }
        return registeredTickerChannels;
    }

    private static enum PolygonStreamAction {
        SUBSCRIBE("subscribe"),
        UNSUBSCRIBE("unsubscribe");

        String apiName;

        private PolygonStreamAction(String apiName) {
            this.apiName = apiName;
        }

        public String getAPIName() {
            return this.apiName;
        }
    }
}

