/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.util.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyUtil {
    private static final Logger LOGGER = LogManager.getLogger(PropertyUtil.class);
    public static final Map<String, Properties> CACHED_PROPERTIES = Collections.synchronizedMap(new HashMap());

    public static String getProperty(String propertyFile, String key) {
        return PropertyUtil.getProperty(propertyFile, key, null);
    }

    public static String getProperty(String propertyFile, String key, String defaultValue) {
        Properties properties;
        if (!CACHED_PROPERTIES.containsKey(propertyFile)) {
            CACHED_PROPERTIES.put(propertyFile, PropertyUtil.loadPropertyFile(propertyFile));
        }
        if ((properties = CACHED_PROPERTIES.get(propertyFile)) != null) {
            return properties.getProperty(key, defaultValue);
        }
        return null;
    }

    public static synchronized Properties loadPropertyFile(String propertyFile) {
        Properties properties = null;
        Properties defaultProperties = null;
        String defaultPropertyFile = propertyFile + ".default";
        InputStream defaultPropertyStream = ClassLoader.getSystemClassLoader().getResourceAsStream(defaultPropertyFile);
        if (defaultPropertyStream != null) {
            defaultProperties = new Properties();
            try {
                defaultProperties.load(defaultPropertyStream);
                LOGGER.debug("Loaded default properties file: " + defaultPropertyFile);
            }
            catch (IOException exception) {
                LOGGER.error("Could not load default property file: " + defaultPropertyFile, (Throwable)exception);
            }
            try {
                defaultPropertyStream.close();
            }
            catch (IOException exception) {
                LOGGER.error("Could not close default property file stream: " + defaultPropertyFile, (Throwable)exception);
            }
        } else {
            LOGGER.warn("No default property file found for: " + propertyFile);
        }
        InputStream propertyStream = ClassLoader.getSystemClassLoader().getResourceAsStream(propertyFile);
        if (propertyStream != null) {
            properties = defaultProperties == null ? new Properties() : new Properties(defaultProperties);
            try {
                properties.load(propertyStream);
                LOGGER.info("Loaded properties file: " + propertyFile);
            }
            catch (IOException exception) {
                LOGGER.error("Could not load property file: " + propertyFile, (Throwable)exception);
            }
            try {
                propertyStream.close();
            }
            catch (IOException exception) {
                LOGGER.error("Could not close property file stream: " + propertyFile, (Throwable)exception);
            }
        } else {
            LOGGER.error("Could not find property file: " + propertyFile);
            if (defaultProperties != null) {
                LOGGER.info("Using default properties for: " + propertyFile);
                properties = defaultProperties;
            }
        }
        return properties;
    }
}

