/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import java.util.ArrayList;
import java.util.Locale;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptCommon;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.bahmni.module.referencedata.labconcepts.service.impl.ConceptMetaDataServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.openmrs.Concept;
import org.openmrs.ConceptClass;
import org.openmrs.ConceptDatatype;
import org.openmrs.ConceptName;
import org.openmrs.ConceptSearchResult;
import org.openmrs.api.AdministrationService;
import org.openmrs.api.ConceptService;
import org.openmrs.api.context.Context;
import org.openmrs.util.LocaleUtility;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LocaleUtility.class, Context.class})
public class ConceptMetaDataServiceImplTest {
    @Mock
    ConceptService conceptService;
    @Mock
    ConceptClass conceptClass;
    @Mock
    ConceptDatatype conceptDataType;
    @Mock
    AdministrationService administrationService;
    @Mock
    Concept concept;
    @InjectMocks
    ConceptMetaDataServiceImpl conceptMetaDataService;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(LocaleUtility.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Context.class, (Class[])new Class[0]);
        ConceptName conceptName = new ConceptName();
        conceptName.setName("ConceptA");
        Mockito.when((Object)this.concept.getName()).thenReturn((Object)conceptName);
    }

    @Test
    public void testGetConceptMetaDataWhenUuidIsPassed() throws Exception {
        ConceptCommon conceptCommon = new ConceptCommon();
        conceptCommon.setClassName("ConceptClass");
        conceptCommon.setDataType("N/A");
        conceptCommon.setLocale("en");
        conceptCommon.setUniqueName("ConceptA");
        conceptCommon.setUuid("123");
        Mockito.when((Object)this.conceptService.getConceptClassByName("ConceptClass")).thenReturn((Object)this.conceptClass);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByName("N/A")).thenReturn((Object)this.conceptDataType);
        Mockito.when((Object)this.conceptService.getConceptByUuid("123")).thenReturn((Object)this.concept);
        Locale locale = new Locale("en");
        Mockito.when((Object)LocaleUtility.fromSpecification((String)"en")).thenReturn((Object)locale);
        Mockito.when((Object)LocaleUtility.isValid((Locale)locale)).thenReturn((Object)true);
        ConceptMetaData conceptMetadata = this.conceptMetaDataService.getConceptMetaData(conceptCommon);
        Assert.assertEquals((Object)this.concept, (Object)conceptMetadata.getExistingConcept());
        Assert.assertEquals((Object)this.conceptClass, (Object)conceptMetadata.getConceptClass());
        Assert.assertEquals((Object)this.conceptDataType, (Object)conceptMetadata.getConceptDatatype());
    }

    @Test
    public void testGetConceptMetaDataWhenLocaleIsPassedAndThereAreNoResults() throws Exception {
        ConceptCommon conceptCommon = new ConceptCommon();
        conceptCommon.setClassName("ConceptClass");
        conceptCommon.setDataType("N/A");
        conceptCommon.setUniqueName("ConceptA");
        conceptCommon.setLocale("en");
        ArrayList locales = new ArrayList();
        Mockito.when((Object)Context.getAdministrationService()).thenReturn((Object)this.administrationService);
        Mockito.when((Object)this.conceptService.getConceptClassByName("ConceptClass")).thenReturn((Object)this.conceptClass);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByName("N/A")).thenReturn((Object)this.conceptDataType);
        Mockito.when((Object)this.administrationService.getAllowedLocales()).thenReturn(locales);
        Locale locale = new Locale("en");
        Mockito.when((Object)LocaleUtility.fromSpecification((String)"en")).thenReturn((Object)locale);
        Mockito.when((Object)LocaleUtility.isValid((Locale)locale)).thenReturn((Object)true);
        ConceptMetaData conceptMetadata = this.conceptMetaDataService.getConceptMetaData(conceptCommon);
        Assert.assertNull((Object)conceptMetadata.getExistingConcept());
        Assert.assertEquals((Object)this.conceptClass, (Object)conceptMetadata.getConceptClass());
        Assert.assertEquals((Object)this.conceptDataType, (Object)conceptMetadata.getConceptDatatype());
    }

    @Test
    public void testGetConceptMetaDataWhenLocaleIsNotPassed() throws Exception {
        ConceptCommon conceptCommon = new ConceptCommon();
        conceptCommon.setClassName("ConceptClass");
        conceptCommon.setDataType("N/A");
        conceptCommon.setUniqueName("ConceptA");
        ArrayList locales = new ArrayList();
        ArrayList<ConceptSearchResult> conceptSearchResults = new ArrayList<ConceptSearchResult>();
        ConceptSearchResult conceptSearchResult = new ConceptSearchResult();
        conceptSearchResult.setConcept(this.concept);
        conceptSearchResults.add(conceptSearchResult);
        Mockito.when((Object)Context.getAdministrationService()).thenReturn((Object)this.administrationService);
        Mockito.when((Object)this.conceptService.getConceptClassByName("ConceptClass")).thenReturn((Object)this.conceptClass);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByName("N/A")).thenReturn((Object)this.conceptDataType);
        Mockito.when((Object)this.administrationService.getAllowedLocales()).thenReturn(locales);
        Mockito.when((Object)this.conceptService.getConcepts("ConceptA", locales, false, null, null, null, null, null, null, null)).thenReturn(conceptSearchResults);
        ConceptMetaData conceptMetadata = this.conceptMetaDataService.getConceptMetaData(conceptCommon);
        Assert.assertEquals((Object)this.concept, (Object)conceptMetadata.getExistingConcept());
        Assert.assertEquals((Object)this.conceptClass, (Object)conceptMetadata.getConceptClass());
        Assert.assertEquals((Object)this.conceptDataType, (Object)conceptMetadata.getConceptDatatype());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetConceptMetaDataWhenLocaleIsInvalid() {
        ConceptCommon conceptCommon = new ConceptCommon();
        conceptCommon.setUniqueName("ConceptA");
        conceptCommon.setLocale("en");
        ArrayList locales = new ArrayList();
        ArrayList<ConceptSearchResult> conceptSearchResults = new ArrayList<ConceptSearchResult>();
        ConceptSearchResult conceptSearchResult = new ConceptSearchResult();
        conceptSearchResult.setConcept(this.concept);
        conceptSearchResults.add(conceptSearchResult);
        Locale locale = new Locale("en");
        Mockito.when((Object)Context.getAdministrationService()).thenReturn((Object)this.administrationService);
        Mockito.when((Object)LocaleUtility.fromSpecification((String)"en")).thenReturn((Object)locale);
        Mockito.when((Object)LocaleUtility.isValid((Locale)locale)).thenReturn((Object)false);
        Mockito.when((Object)this.administrationService.getAllowedLocales()).thenReturn(locales);
        Mockito.when((Object)this.conceptService.getConcepts("ConceptA", locales, false, null, null, null, null, null, null, null)).thenReturn(conceptSearchResults);
        this.conceptMetaDataService.getConceptMetaData(conceptCommon);
    }

    @Test
    public void testGetConceptMetaDataWhenLocaleIsPassed() throws Exception {
        ConceptCommon conceptCommon = new ConceptCommon();
        conceptCommon.setUniqueName("ConceptA");
        conceptCommon.setLocale("en");
        ArrayList<ConceptSearchResult> conceptSearchResults = new ArrayList<ConceptSearchResult>();
        ConceptSearchResult conceptSearchResult = new ConceptSearchResult();
        conceptSearchResult.setConcept(this.concept);
        conceptSearchResults.add(conceptSearchResult);
        ArrayList locales = new ArrayList();
        Locale locale = new Locale("en");
        Mockito.when((Object)Context.getAdministrationService()).thenReturn((Object)this.administrationService);
        Mockito.when((Object)LocaleUtility.fromSpecification((String)"en")).thenReturn((Object)locale);
        Mockito.when((Object)LocaleUtility.isValid((Locale)locale)).thenReturn((Object)true);
        Mockito.when((Object)this.administrationService.getAllowedLocales()).thenReturn(locales);
        Mockito.when((Object)this.conceptService.getConcepts("ConceptA", locales, false, null, null, null, null, null, null, null)).thenReturn(conceptSearchResults);
        ConceptMetaData conceptMetadata = this.conceptMetaDataService.getConceptMetaData(conceptCommon);
        Assert.assertEquals((Object)this.concept, (Object)conceptMetadata.getExistingConcept());
    }
}

