/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import org.bahmni.module.referencedata.labconcepts.model.DrugMetaData;
import org.bahmni.module.referencedata.labconcepts.service.impl.DrugMetaDataServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.openmrs.Concept;
import org.openmrs.Drug;
import org.openmrs.api.ConceptService;

public class DrugMetaDataServiceImplTest {
    @Mock
    ConceptService conceptService;
    private static Integer DRUG_CONCEPT = 1;
    private static Integer DOSAGE_FORM_CONCEPT = 2;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void ensureDrugMetadataIsProperWithAllValid() {
        org.bahmni.module.referencedata.labconcepts.contract.Drug drug = new org.bahmni.module.referencedata.labconcepts.contract.Drug();
        drug.setUuid("uuid");
        drug.setGenericName("genericName");
        drug.setDosageForm("dosageForm");
        Drug drugInDb1 = new Drug();
        drugInDb1.setUuid("uuid");
        Drug drugInDb2 = new Drug();
        drugInDb2.setUuid("uuid");
        Drug mrsDrug = new Drug(Integer.valueOf(1234));
        Mockito.when((Object)this.conceptService.getConceptByName("genericName")).thenReturn((Object)new Concept(DRUG_CONCEPT));
        Mockito.when((Object)this.conceptService.getConceptByName("dosageForm")).thenReturn((Object)new Concept(DOSAGE_FORM_CONCEPT));
        Mockito.when((Object)this.conceptService.getDrugByUuid("uuid")).thenReturn((Object)mrsDrug);
        Mockito.when((Object)this.conceptService.getConceptClassByUuid("8d490dfc-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByUuid("8d4a4c94-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        DrugMetaDataServiceImpl drugMetaDataService = new DrugMetaDataServiceImpl(this.conceptService);
        DrugMetaData drugMetaData = drugMetaDataService.getDrugMetaData(drug);
        Assert.assertNotNull((Object)drugMetaData);
        Assert.assertNotNull((Object)drugMetaData.getExistingDrug());
        Assert.assertEquals((Object)DOSAGE_FORM_CONCEPT, (Object)drugMetaData.getDosageForm().getId());
        Assert.assertEquals((Object)DRUG_CONCEPT, (Object)drugMetaData.getDrugConcept().getId());
    }

    @Test
    public void existingDrugIsNullWhenUuidIsInvalid() {
        org.bahmni.module.referencedata.labconcepts.contract.Drug drug = new org.bahmni.module.referencedata.labconcepts.contract.Drug();
        drug.setUuid("uuid");
        drug.setGenericName("genericName");
        drug.setDosageForm("dosageForm");
        Drug drugInDb1 = new Drug();
        drugInDb1.setUuid("uuid");
        Drug drugInDb2 = new Drug();
        drugInDb2.setUuid("uuid");
        new Drug(Integer.valueOf(1234));
        Mockito.when((Object)this.conceptService.getConceptByName("genericName")).thenReturn((Object)new Concept(DRUG_CONCEPT));
        Mockito.when((Object)this.conceptService.getConceptByName("dosageForm")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getDrugByUuid("uuid")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getConceptClassByUuid("8d490dfc-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByUuid("8d4a4c94-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        DrugMetaDataServiceImpl drugMetaDataService = new DrugMetaDataServiceImpl(this.conceptService);
        DrugMetaData drugMetaData = drugMetaDataService.getDrugMetaData(drug);
        Assert.assertNotNull((Object)drugMetaData);
        Assert.assertNull((Object)drugMetaData.getExistingDrug());
        Assert.assertEquals((Object)DRUG_CONCEPT, (Object)drugMetaData.getDrugConcept().getId());
    }

    @Test
    public void newDrugWithInvalidDosageForm() {
        org.bahmni.module.referencedata.labconcepts.contract.Drug drug = new org.bahmni.module.referencedata.labconcepts.contract.Drug();
        drug.setGenericName("genericName");
        drug.setDosageForm("dosageForm");
        new Drug(Integer.valueOf(1234));
        Mockito.when((Object)this.conceptService.getConceptByName("genericName")).thenReturn((Object)new Concept(DRUG_CONCEPT));
        Mockito.when((Object)this.conceptService.getConceptByName("dosageForm")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getDrugByUuid("uuid")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getConceptClassByUuid("8d490dfc-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        Mockito.when((Object)this.conceptService.getConceptDatatypeByUuid("8d4a4c94-c2cc-11de-8d13-0010c6dffd0f")).thenReturn(null);
        DrugMetaDataServiceImpl drugMetaDataService = new DrugMetaDataServiceImpl(this.conceptService);
        DrugMetaData drugMetaData = drugMetaDataService.getDrugMetaData(drug);
        Assert.assertNotNull((Object)drugMetaData);
        Assert.assertNull((Object)drugMetaData.getExistingDrug());
        Assert.assertNull((Object)drugMetaData.getDosageForm());
        Assert.assertEquals((Object)DRUG_CONCEPT, (Object)drugMetaData.getDrugConcept().getId());
    }
}

