/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bahmni.module.referencedata.contract.ConceptDetails;
import org.openmrs.Concept;
import org.openmrs.ConceptName;
import org.openmrs.ConceptNumeric;
import org.openmrs.api.ConceptNameType;
import org.openmrs.api.ConceptService;
import org.openmrs.api.context.Context;
import org.openmrs.module.emrapi.utils.HibernateLazyLoader;
import org.openmrs.util.LocaleUtility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConceptHelper {
    private ConceptService conceptService;

    @Autowired
    public ConceptHelper(ConceptService conceptService) {
        this.conceptService = conceptService;
    }

    public List<Concept> getConceptsForNames(Collection<String> conceptNames) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        if (conceptNames != null) {
            for (String conceptName : conceptNames) {
                List conceptsByName = this.conceptService.getConceptsByName(conceptName.replaceAll("%20", " "));
                if (!CollectionUtils.isNotEmpty((Collection)conceptsByName)) continue;
                block1: for (Concept concept : conceptsByName) {
                    for (ConceptName conceptNameObj : concept.getNames()) {
                        if (!conceptNameObj.getName().equalsIgnoreCase(conceptName) || !conceptNameObj.isFullySpecifiedName().booleanValue()) continue;
                        concepts.add(concept);
                        continue block1;
                    }
                }
            }
        }
        return concepts;
    }

    public Set<ConceptDetails> getLeafConceptDetails(List<Concept> obsConcepts, boolean withoutAttributes) {
        if (obsConcepts != null && !obsConcepts.isEmpty()) {
            LinkedHashSet<ConceptDetails> leafConcepts = new LinkedHashSet<ConceptDetails>();
            for (Concept concept : obsConcepts) {
                this.addLeafConcepts(concept, null, leafConcepts, withoutAttributes);
            }
            return leafConcepts;
        }
        return Collections.EMPTY_SET;
    }

    protected void addLeafConcepts(Concept rootConcept, Concept parentConcept, Set<ConceptDetails> leafConcepts, boolean withoutAttributes) {
        if (rootConcept != null) {
            if (rootConcept.isSet().booleanValue()) {
                for (Concept setMember : rootConcept.getSetMembers()) {
                    this.addLeafConcepts(setMember, rootConcept, leafConcepts, withoutAttributes);
                }
            } else if (!this.shouldBeExcluded(rootConcept)) {
                Concept conceptToAdd = rootConcept;
                if (parentConcept != null && !withoutAttributes && this.hasConceptDetailsClass(parentConcept)) {
                    conceptToAdd = parentConcept;
                }
                ConceptDetails conceptDetails = this.createConceptDetails(conceptToAdd);
                this.addAttributes(conceptDetails, parentConcept);
                leafConcepts.add(conceptDetails);
            }
        }
    }

    private void addAttributes(ConceptDetails conceptDetails, Concept parentConcept) {
        if (parentConcept != null && this.hasConceptDetailsClass(parentConcept)) {
            for (Concept concept : parentConcept.getSetMembers()) {
                if ("Unknown".equals(concept.getConceptClass().getName())) {
                    conceptDetails.addAttribute("Unknown Concept", this.getConceptName(concept, ConceptNameType.FULLY_SPECIFIED));
                }
                if (!"Abnormal".equals(concept.getConceptClass().getName())) continue;
                conceptDetails.addAttribute("Abnormal Concept", this.getConceptName(concept, ConceptNameType.FULLY_SPECIFIED));
            }
        }
    }

    private boolean hasConceptDetailsClass(Concept parentConcept) {
        return "Concept Details".equals(parentConcept.getConceptClass().getName());
    }

    private ConceptDetails createConceptDetails(Concept conceptToAdd) {
        String conceptShortName;
        Concept concept = (Concept)new HibernateLazyLoader().load((Object)conceptToAdd);
        String fullNameInLocale = this.getConceptNameInLocale(concept, ConceptNameType.FULLY_SPECIFIED, false);
        String shortNameInLocale = this.getConceptNameInLocale(concept, ConceptNameType.SHORT, false);
        String conceptFullName = fullNameInLocale != null ? fullNameInLocale : this.getConceptNameInLocale(concept, ConceptNameType.FULLY_SPECIFIED, true);
        String string = conceptShortName = shortNameInLocale != null ? shortNameInLocale : fullNameInLocale;
        if (conceptShortName == null) {
            String defaultLocaleShortName = this.getConceptNameInLocale(concept, ConceptNameType.SHORT, true);
            conceptShortName = defaultLocaleShortName != null ? defaultLocaleShortName : conceptFullName;
        }
        ConceptDetails conceptDetails = new ConceptDetails();
        conceptDetails.setName(conceptShortName);
        conceptDetails.setFullName(conceptFullName);
        if (concept.isNumeric()) {
            ConceptNumeric numericConcept = (ConceptNumeric)concept;
            conceptDetails.setUnits(numericConcept.getUnits());
            conceptDetails.setHiNormal(numericConcept.getHiNormal());
            conceptDetails.setLowNormal(numericConcept.getLowNormal());
        }
        return conceptDetails;
    }

    private String getConceptName(Concept concept, ConceptNameType conceptNameType) {
        String conceptNameInLocale = this.getConceptNameInLocale(concept, conceptNameType, false);
        return conceptNameInLocale != null ? conceptNameInLocale : this.getConceptNameInLocale(concept, conceptNameType, true);
    }

    private String getConceptNameInLocale(Concept concept, ConceptNameType conceptNameType, boolean isDefaultLocale) {
        Locale locale = isDefaultLocale ? LocaleUtility.getDefaultLocale() : LocaleUtility.fromSpecification((String)Context.getAuthenticatedUser().getUserProperty("defaultLocale"));
        ConceptName conceptName = concept.getName(locale, conceptNameType, null);
        return conceptName != null ? conceptName.getName() : null;
    }

    private boolean shouldBeExcluded(Concept rootConcept) {
        return "Abnormal".equals(rootConcept.getConceptClass().getName()) || "Duration".equals(rootConcept.getConceptClass().getName()) || "Unknown".equals(rootConcept.getConceptClass().getName());
    }

    public Set<ConceptDetails> getConceptDetails(List<Concept> conceptNames) {
        LinkedHashSet<ConceptDetails> conceptDetails = new LinkedHashSet<ConceptDetails>();
        for (Concept concept : conceptNames) {
            if (concept == null) continue;
            conceptDetails.add(this.createConceptDetails(concept));
        }
        return conceptDetails;
    }

    public Set<Integer> getConceptIds(List<Concept> conceptNames) {
        LinkedHashSet<Integer> conceptIds = new LinkedHashSet<Integer>();
        for (Concept concept : conceptNames) {
            if (concept == null) continue;
            conceptIds.add(concept.getConceptId());
        }
        return conceptIds;
    }

    public List<Concept> getParentConcepts(Concept concept) {
        return this.conceptService.getConceptsByAnswer(concept);
    }

    public Set<String> getChildConceptNames(List<Concept> conceptsForNames) {
        LinkedHashSet<String> conceptDetails = new LinkedHashSet<String>();
        this.getConceptNames(conceptDetails, conceptsForNames);
        return conceptDetails;
    }

    private void getConceptNames(Set<String> conceptDetails, List<Concept> concepts) {
        for (Concept concept : concepts) {
            if (!concept.isRetired().booleanValue()) {
                conceptDetails.add(this.getConceptName(concept, ConceptNameType.FULLY_SPECIFIED));
            }
            this.getConceptNames(conceptDetails, concept.getSetMembers());
        }
    }

    public Set<org.bahmni.module.referencedata.contract.ConceptName> getLeafConceptNames(List<Concept> concepts) {
        LinkedHashSet<org.bahmni.module.referencedata.contract.ConceptName> leafConcepts = new LinkedHashSet<org.bahmni.module.referencedata.contract.ConceptName>();
        this.getLeafConceptName(leafConcepts, concepts);
        return leafConcepts;
    }

    private void getLeafConceptName(Set<org.bahmni.module.referencedata.contract.ConceptName> leafConcepts, List<Concept> concepts) {
        for (Concept concept : concepts) {
            if (!concept.isSet().booleanValue() && !concept.isRetired().booleanValue()) {
                String fullySpecifiedName = this.getConceptName(concept, ConceptNameType.FULLY_SPECIFIED);
                String shortName = this.getConceptName(concept, ConceptNameType.SHORT);
                leafConcepts.add(new org.bahmni.module.referencedata.contract.ConceptName(fullySpecifiedName, shortName));
                continue;
            }
            if (!concept.isSet().booleanValue() || concept.isRetired().booleanValue()) continue;
            this.getLeafConceptName(leafConcepts, concept.getSetMembers());
        }
    }
}

