/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptCommon;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptExtension;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.openmrs.Concept;
import org.openmrs.api.ConceptNameType;
import org.openmrs.api.context.Context;

public class ConceptCommonMapper {
    public Concept map(ConceptCommon conceptCommon, ConceptMetaData conceptMetaData) {
        Concept openmrsConcept = new Concept();
        if (conceptMetaData.getExistingConcept() != null) {
            openmrsConcept = conceptMetaData.getExistingConcept();
        } else if (StringUtils.isNotBlank((CharSequence)conceptCommon.getUuid())) {
            openmrsConcept.setUuid(conceptCommon.getUuid());
        }
        String displayName = conceptCommon.getDisplayName();
        openmrsConcept = ConceptExtension.addConceptName(openmrsConcept, ConceptExtension.getConceptName(conceptCommon.getUniqueName(), ConceptNameType.FULLY_SPECIFIED, conceptMetaData.getLocale()));
        if (displayName != null) {
            openmrsConcept = ConceptExtension.addConceptName(openmrsConcept, ConceptExtension.getConceptName(conceptCommon.getDisplayName(), ConceptNameType.SHORT, conceptMetaData.getLocale()));
        }
        if (!StringUtils.isBlank((CharSequence)conceptCommon.getDescription())) {
            this.setDescriptionWithLocale(conceptCommon.getDescription(), conceptMetaData.getLocale(), openmrsConcept);
        }
        openmrsConcept.setConceptClass(conceptMetaData.getConceptClass());
        return openmrsConcept;
    }

    private void setDescriptionWithLocale(String description, Locale locale, Concept concept) {
        if (this.descriptionAlreadyExistsInLocale(concept, locale)) {
            concept.getDescription(locale).setDescription(description);
        } else {
            concept.addDescription(ConceptExtension.constructDescription(description, locale));
        }
    }

    private boolean descriptionAlreadyExistsInLocale(Concept concept, Locale locale) {
        Locale locale2 = locale = locale != null ? locale : Context.getLocale();
        if (concept.getDescription(locale) == null) {
            return false;
        }
        return concept.getDescription(locale).getLocale().equals(locale);
    }
}

