/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bahmni.module.referencedata.labconcepts.contract.Concept;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptAnswerMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptCommonMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptExtension;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptNumericMapper;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.openmrs.ConceptAnswer;
import org.openmrs.ConceptDescription;
import org.openmrs.ConceptMap;
import org.openmrs.ConceptName;
import org.openmrs.ConceptReferenceTerm;
import org.openmrs.api.context.Context;

public class ConceptMapper {
    private final ConceptAnswerMapper conceptAnswerMapper = new ConceptAnswerMapper();
    private final ConceptNumericMapper conceptNumericMapper = new ConceptNumericMapper();
    private final ConceptCommonMapper conceptCommonMapper = new ConceptCommonMapper();

    public org.openmrs.Concept map(Concept conceptData, ConceptMetaData conceptMetaData, List<ConceptAnswer> answers) {
        org.openmrs.Concept concept = this.conceptCommonMapper.map(conceptData, conceptMetaData);
        for (String conceptName : conceptData.getSynonyms()) {
            concept = ConceptExtension.addConceptName(concept, ConceptExtension.getConceptName(conceptName, conceptMetaData.getLocale()));
        }
        if (conceptMetaData.getConceptDatatype().isNumeric()) {
            concept = this.conceptNumericMapper.map(concept, conceptData, conceptMetaData.getExistingConcept());
        }
        concept.setDatatype(conceptMetaData.getConceptDatatype());
        concept = this.conceptAnswerMapper.map(concept, answers);
        return concept;
    }

    public org.openmrs.Concept addConceptMap(org.openmrs.Concept mappedConcept, ConceptMap conceptMap) {
        if (conceptMap == null) {
            return mappedConcept;
        }
        for (ConceptMap existingMap : mappedConcept.getConceptMappings()) {
            if (!existingMap.getConceptReferenceTerm().equals((Object)conceptMap.getConceptReferenceTerm())) continue;
            return mappedConcept;
        }
        mappedConcept.addConceptMapping(conceptMap);
        return mappedConcept;
    }

    public Concept map(org.openmrs.Concept concept) {
        ConceptName shortName;
        String conceptDescription = null;
        String conceptShortname = null;
        String name = concept.getName(Context.getLocale()).getName();
        ConceptDescription description = concept.getDescription(Context.getLocale());
        if (description != null) {
            conceptDescription = description.getDescription();
        }
        if ((shortName = concept.getShortNameInLocale(Context.getLocale())) != null) {
            conceptShortname = shortName.getName();
        }
        String conceptClass = concept.getConceptClass().getName();
        String conceptDatatype = concept.getDatatype().getName();
        List<String> conceptSynonyms = this.getSynonyms(concept);
        List<String> conceptAnswers = this.getAnswers(concept);
        Collection conceptMappings = concept.getConceptMappings();
        ArrayList<org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm> referenceTerms = new ArrayList<org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm>();
        for (ConceptMap conceptMapping : conceptMappings) {
            ConceptReferenceTerm term = conceptMapping.getConceptReferenceTerm();
            referenceTerms.add(new org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm(term.getCode(), conceptMapping.getConceptMapType().getName(), term.getConceptSource().getName()));
        }
        String uuid = concept.getUuid();
        return new Concept(uuid, name, conceptDescription, conceptClass, conceptShortname, referenceTerms, conceptSynonyms, conceptAnswers, conceptDatatype);
    }

    private List<String> getAnswers(org.openmrs.Concept concept) {
        ArrayList<String> answers = new ArrayList<String>();
        for (ConceptAnswer conceptAnswer : concept.getAnswers()) {
            answers.add(conceptAnswer.getAnswerConcept().getName(Context.getLocale()).getName());
        }
        return answers;
    }

    private List<String> getSynonyms(org.openmrs.Concept concept) {
        ArrayList<String> synonyms = new ArrayList<String>();
        for (ConceptName synonym : concept.getSynonyms()) {
            synonyms.add(synonym.getName());
        }
        return synonyms;
    }

    public List<Concept> mapAll(org.openmrs.Concept concept) {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        for (ConceptAnswer conceptAnswer : concept.getAnswers()) {
            conceptList.addAll(this.mapAll(conceptAnswer.getAnswerConcept()));
        }
        conceptList.add(this.map(concept));
        return conceptList;
    }
}

