/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bahmni.module.referencedata.labconcepts.contract.Concept;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptSet;
import org.bahmni.module.referencedata.labconcepts.contract.Concepts;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptCommonMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.SetMemberMapper;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.openmrs.ConceptDescription;
import org.openmrs.ConceptMap;
import org.openmrs.ConceptName;
import org.openmrs.ConceptReferenceTerm;
import org.openmrs.api.context.Context;

public class ConceptSetMapper {
    private final ConceptMapper conceptMapper = new ConceptMapper();
    private final ConceptCommonMapper conceptCommonMapper = new ConceptCommonMapper();
    private final SetMemberMapper setMemberMapper = new SetMemberMapper();

    public org.openmrs.Concept map(ConceptSet conceptSet, List<org.openmrs.Concept> childConcepts, ConceptMetaData conceptMetaData) {
        org.openmrs.Concept concept = this.conceptCommonMapper.map(conceptSet, conceptMetaData);
        concept.setSet(Boolean.valueOf(true));
        concept.setDatatype(conceptMetaData.getConceptDatatype());
        concept = this.setMemberMapper.map(concept, childConcepts);
        return concept;
    }

    public ConceptSet map(org.openmrs.Concept concept) {
        ConceptName shortName;
        String conceptDescription = null;
        String conceptShortname = null;
        String name = concept.getName(Context.getLocale()).getName();
        ConceptDescription description = concept.getDescription(Context.getLocale());
        if (description != null) {
            conceptDescription = description.getDescription();
        }
        if ((shortName = concept.getShortNameInLocale(Context.getLocale())) != null) {
            conceptShortname = shortName.getName();
        }
        String conceptClass = concept.getConceptClass().getName();
        List<String> children = this.getSetMembers(concept);
        Collection conceptMappings = concept.getConceptMappings();
        ArrayList<org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm> referenceTerms = new ArrayList<org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm>();
        for (ConceptMap conceptMapping : conceptMappings) {
            ConceptReferenceTerm term = conceptMapping.getConceptReferenceTerm();
            referenceTerms.add(new org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm(term.getCode(), conceptMapping.getConceptMapType().getName(), term.getConceptSource().getName()));
        }
        String uuid = concept.getUuid();
        ConceptSet conceptSet = new ConceptSet(uuid, name, conceptDescription, conceptClass, conceptShortname, referenceTerms, children);
        return conceptSet;
    }

    private List<String> getSetMembers(org.openmrs.Concept concept) {
        ArrayList<String> setMembers = new ArrayList<String>();
        for (org.openmrs.Concept setMember : concept.getSetMembers()) {
            setMembers.add(setMember.getName(Context.getLocale()).getName());
        }
        return setMembers;
    }

    public Concepts mapAll(org.openmrs.Concept concept) {
        ArrayList<ConceptSet> conceptSetList = new ArrayList<ConceptSet>();
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        for (org.openmrs.Concept setMember : concept.getSetMembers()) {
            if (setMember.isSet().booleanValue()) {
                Concepts concepts = this.mapAll(setMember);
                conceptSetList.addAll(concepts.getConceptSetList());
                conceptList.addAll(concepts.getConceptList());
                continue;
            }
            conceptList.addAll(this.conceptMapper.mapAll(setMember));
        }
        conceptSetList.add(this.map(concept));
        Concepts concepts = new Concepts();
        concepts.setConceptList(conceptList);
        concepts.setConceptSetList(conceptSetList);
        return concepts;
    }
}

