/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import org.bahmni.module.referencedata.labconcepts.mapper.ConceptExtension;
import org.bahmni.module.referencedata.labconcepts.mapper.DrugMetaDataMapper;
import org.bahmni.module.referencedata.labconcepts.model.DrugMetaData;
import org.openmrs.Concept;
import org.openmrs.Drug;
import org.openmrs.api.ConceptNameType;
import org.openmrs.api.context.Context;
import org.springframework.util.Assert;

public class DrugMapper {
    private final DrugMetaDataMapper drugMetaDataMapper = new DrugMetaDataMapper();

    public Drug map(org.bahmni.module.referencedata.labconcepts.contract.Drug drug, DrugMetaData drugMetaData) {
        Assert.notNull((Object)drugMetaData.getDosageForm(), (String)"The dosage form should not be null");
        Assert.notNull((Object)drugMetaData.getDrugConcept(), (String)"The drug concept should not be null");
        Drug conceptDrug = this.drugMetaDataMapper.map(drugMetaData);
        conceptDrug.setName(drug.getName());
        ConceptExtension.addConceptName(conceptDrug.getConcept(), ConceptExtension.getConceptName(drug.getGenericName(), ConceptNameType.FULLY_SPECIFIED));
        conceptDrug.setCombination(drug.isCombination());
        conceptDrug.setStrength(drug.getStrength());
        conceptDrug.setMaximumDailyDose(drug.doubleMaximumDose());
        conceptDrug.setMinimumDailyDose(drug.doubleMinimumDose());
        return conceptDrug;
    }

    public org.bahmni.module.referencedata.labconcepts.contract.Drug map(Drug conceptDrug) {
        org.bahmni.module.referencedata.labconcepts.contract.Drug drug = new org.bahmni.module.referencedata.labconcepts.contract.Drug();
        drug.setName(conceptDrug.getName());
        drug.setShortName(this.getShortNameFrom(conceptDrug.getConcept()));
        drug.setGenericName(this.getNameFrom(conceptDrug.getConcept()));
        drug.setDosageForm(this.getNameFrom(conceptDrug.getDosageForm()));
        drug.setStrength(conceptDrug.getStrength());
        drug.setUuid(conceptDrug.getUuid());
        drug.setCombination(conceptDrug.getCombination());
        drug.setMaximumDose(conceptDrug.getMaximumDailyDose() == null ? "" : conceptDrug.getMaximumDailyDose().toString());
        drug.setMinimumDose(conceptDrug.getMinimumDailyDose() == null ? "" : conceptDrug.getMinimumDailyDose().toString());
        return drug;
    }

    private String getShortNameFrom(Concept concept) {
        if (concept != null && concept.getShortNameInLocale(Context.getLocale()) != null) {
            return concept.getShortNameInLocale(Context.getLocale()).getName();
        }
        return null;
    }

    private String getNameFrom(Concept concept) {
        if (concept != null && concept.getName(Context.getLocale()) != null) {
            return concept.getName(Context.getLocale()).getName();
        }
        return null;
    }
}

