/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import java.util.List;
import org.bahmni.module.referencedata.labconcepts.contract.Resource;
import org.openmrs.Concept;
import org.openmrs.ConceptSet;
import org.openmrs.api.context.Context;

public abstract class ResourceMapper {
    public static final double DEFAULT_SORT_ORDER = 999.0;
    String parentConceptName;

    protected ResourceMapper(String parentConceptName) {
        this.parentConceptName = parentConceptName;
    }

    public abstract <T extends Resource> T map(Concept var1);

    <R extends Resource> R mapResource(R resource, Concept concept) {
        resource.setName(concept.getName(Context.getLocale()).getName());
        resource.setIsActive(concept.isRetired() == false);
        resource.setId(concept.getUuid());
        resource.setDateCreated(concept.getDateCreated());
        resource.setLastUpdated(concept.getDateChanged());
        return resource;
    }

    Double getSortWeight(Concept concept) {
        List conceptSets = Context.getConceptService().getSetsContainingConcept(concept);
        if (conceptSets == null) {
            return 999.0;
        }
        for (ConceptSet conceptSet : conceptSets) {
            if (!conceptSet.getConceptSet().getName(Context.getLocale()).getName().equals(this.parentConceptName)) continue;
            return conceptSet.getSortWeight() != null ? conceptSet.getSortWeight() : 999.0;
        }
        return 999.0;
    }
}

