/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import java.util.Collection;
import java.util.List;
import org.openmrs.Concept;
import org.openmrs.api.context.Context;

public class SetMemberMapper {
    public Concept map(Concept concept, List<Concept> childConcepts) {
        this.removeAllSetMembers(concept);
        for (int i = 0; i < childConcepts.size(); ++i) {
            this.addSetMember(concept, childConcepts.get(i), i);
        }
        return concept;
    }

    private void removeAllSetMembers(Concept concept) {
        Collection conceptSets = concept.getConceptSets();
        conceptSets.clear();
        concept.setConceptSets(conceptSets);
    }

    private Concept addSetMember(Concept concept, Concept childConcept, Integer sortWeight) {
        if (this.ifChildExists(concept, childConcept)) {
            return concept;
        }
        concept.addSetMember(childConcept, sortWeight.intValue());
        return concept;
    }

    private boolean ifChildExists(Concept concept, Concept childConcept) {
        for (Concept child : concept.getSetMembers()) {
            if (!child.getName(Context.getLocale()).getName().equals(childConcept.getName(Context.getLocale()).getName())) continue;
            return true;
        }
        return false;
    }
}

