/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.mapper;

import org.bahmni.module.referencedata.labconcepts.contract.LabTest;
import org.bahmni.module.referencedata.labconcepts.contract.Panel;
import org.bahmni.module.referencedata.labconcepts.contract.TestsAndPanels;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptExtension;
import org.bahmni.module.referencedata.labconcepts.mapper.LabTestMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.PanelMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.ResourceMapper;
import org.openmrs.Concept;

public class TestAndPanelMapper
extends ResourceMapper {
    private final LabTestMapper labTestMapper = new LabTestMapper();
    private PanelMapper panelMapper = new PanelMapper();

    public TestAndPanelMapper() {
        super(null);
    }

    public TestsAndPanels map(Concept sampleConcept) {
        TestsAndPanels testsAndPanels = new TestsAndPanels();
        for (Concept concept : sampleConcept.getSetMembers()) {
            if (!ConceptExtension.isActive(concept)) continue;
            this.addConcept(testsAndPanels, concept);
        }
        return testsAndPanels;
    }

    private void addConcept(TestsAndPanels testsAndPanels, Concept concept) {
        if (ConceptExtension.isOfAnyConceptClass(concept, LabTest.LAB_TEST_CONCEPT_CLASSES)) {
            LabTest test = this.labTestMapper.map(concept);
            testsAndPanels.addTest(test);
        } else if (ConceptExtension.isOfConceptClassByUUID(concept, "8d492026-c2cc-11de-8d13-0010c6dffd0f")) {
            Panel panel = this.panelMapper.map(concept);
            testsAndPanels.addPanel(panel);
        }
    }
}

