/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptCommon;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.bahmni.module.referencedata.labconcepts.service.ConceptMetaDataService;
import org.openmrs.Concept;
import org.openmrs.ConceptClass;
import org.openmrs.ConceptDatatype;
import org.openmrs.ConceptSearchResult;
import org.openmrs.api.AdministrationService;
import org.openmrs.api.ConceptService;
import org.openmrs.api.context.Context;
import org.openmrs.util.LocaleUtility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConceptMetaDataServiceImpl
implements ConceptMetaDataService {
    @Autowired
    private ConceptService conceptService;

    @Override
    public ConceptMetaData getConceptMetaData(ConceptCommon conceptCommon) {
        ConceptClass conceptClass = this.conceptService.getConceptClassByName(conceptCommon.getClassName());
        Concept existingConcept = this.getExistingConcept(conceptCommon.getUniqueName(), conceptCommon.getUuid());
        ConceptDatatype conceptDatatype = this.conceptService.getConceptDatatypeByName(conceptCommon.getDataType());
        return new ConceptMetaData(existingConcept, conceptDatatype, conceptClass, this.getLocale(conceptCommon.getLocale()));
    }

    private Concept getExistingConcept(String uniqueName, String uuid) {
        if (uuid != null) {
            return this.conceptService.getConceptByUuid(uuid);
        }
        Concept conceptByName = this.conceptService.getConceptByName(uniqueName);
        if (conceptByName != null) {
            return conceptByName;
        }
        AdministrationService administrationService = Context.getAdministrationService();
        List locales = administrationService.getAllowedLocales();
        List conceptSearchResults = this.conceptService.getConcepts(uniqueName, locales, false, null, null, null, null, null, null, null);
        if (conceptSearchResults.isEmpty()) {
            return null;
        }
        return this.getMatchingConcept(conceptSearchResults, uniqueName);
    }

    private Concept getMatchingConcept(List<ConceptSearchResult> conceptSearchResults, String uniqueName) {
        for (ConceptSearchResult conceptSearchResult : conceptSearchResults) {
            if (!conceptSearchResult.getConcept().getName().toString().equalsIgnoreCase(uniqueName)) continue;
            return conceptSearchResult.getConcept();
        }
        return null;
    }

    private Locale getLocale(String locale) {
        if (StringUtils.isEmpty((CharSequence)locale)) {
            return Context.getLocale();
        }
        Locale locale1 = LocaleUtility.fromSpecification((String)locale);
        if (!LocaleUtility.isValid((Locale)locale1)) {
            throw new IllegalArgumentException("The locale " + locale + " is not valid");
        }
        return locale1;
    }
}

