/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bahmni.module.referencedata.labconcepts.model.DrugMetaData;
import org.bahmni.module.referencedata.labconcepts.service.DrugMetaDataService;
import org.openmrs.Concept;
import org.openmrs.ConceptClass;
import org.openmrs.Drug;
import org.openmrs.api.ConceptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugMetaDataServiceImpl
implements DrugMetaDataService {
    private final ConceptService conceptService;

    @Autowired
    public DrugMetaDataServiceImpl(ConceptService conceptService) {
        this.conceptService = conceptService;
    }

    @Override
    public DrugMetaData getDrugMetaData(org.bahmni.module.referencedata.labconcepts.contract.Drug drug) {
        Concept dosageFormConcept = this.conceptService.getConceptByName(drug.getDosageForm());
        Drug existingDrug = this.getExistingDrug(drug, dosageFormConcept);
        Concept drugConcept = this.conceptService.getConceptByName(drug.getGenericName());
        ConceptClass drugConceptClass = this.conceptService.getConceptClassByUuid("8d490dfc-c2cc-11de-8d13-0010c6dffd0f");
        return new DrugMetaData(existingDrug, drugConcept, dosageFormConcept, drugConceptClass);
    }

    private Drug getExistingDrug(org.bahmni.module.referencedata.labconcepts.contract.Drug drug, Concept dosageFormConcept) {
        if (!StringUtils.isBlank((CharSequence)drug.getUuid())) {
            return this.conceptService.getDrugByUuid(drug.getUuid());
        }
        if (dosageFormConcept == null) {
            return null;
        }
        List drugs = this.conceptService.getDrugs(drug.getName());
        for (Drug mrsDrug : drugs) {
            if (!mrsDrug.getStrength().equals(drug.getStrength()) || !mrsDrug.getDosageForm().getConceptId().equals(dosageFormConcept.getConceptId()) || !mrsDrug.getName().equals(drug.getName())) continue;
            return mrsDrug;
        }
        return null;
    }
}

