/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.bahmni.module.referencedata.labconcepts.service.ReferenceDataConceptReferenceTermService;
import org.openmrs.ConceptMap;
import org.openmrs.ConceptMapType;
import org.openmrs.ConceptReferenceTerm;
import org.openmrs.ConceptSource;
import org.openmrs.api.APIException;
import org.openmrs.api.ConceptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferenceDataConceptReferenceTermServiceImpl
implements ReferenceDataConceptReferenceTermService {
    @Autowired
    private ConceptService conceptService;

    @Override
    public ConceptReferenceTerm getConceptReferenceTerm(String referenceTermCode, String referenceTermSource) {
        ConceptSource conceptReferenceSource = this.conceptService.getConceptSourceByName(referenceTermSource);
        ConceptReferenceTerm conceptReferenceTerm = this.conceptService.getConceptReferenceTermByCode(referenceTermCode, conceptReferenceSource);
        this.validate(conceptReferenceSource, conceptReferenceTerm);
        return conceptReferenceTerm;
    }

    @Override
    public ConceptMap getConceptMap(org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm conceptReferenceTermData) {
        ConceptMap conceptMap = null;
        if (conceptReferenceTermData != null && this.hasReferenceTermAndSource(conceptReferenceTermData)) {
            ConceptReferenceTerm conceptReferenceTerm = this.getConceptReferenceTerm(conceptReferenceTermData.getReferenceTermCode(), conceptReferenceTermData.getReferenceTermSource());
            String mapType = conceptReferenceTermData.getReferenceTermRelationship();
            ConceptMapType conceptMapType = this.conceptService.getConceptMapTypeByName(mapType);
            if (conceptMapType == null) {
                conceptMapType = this.conceptService.getConceptMapTypeByUuid("35543629-7d8c-11e1-909d-c80aa9edcf4e");
            }
            conceptMap = new ConceptMap(conceptReferenceTerm, conceptMapType);
        }
        return conceptMap;
    }

    @Override
    public ConceptReferenceTerm saveOrUpdate(org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm conceptReferenceTerm) {
        ConceptReferenceTerm openmrsConceptReferenceTerm = this.fetchConceptReferenceTerm(conceptReferenceTerm.getReferenceTermSource(), conceptReferenceTerm.getReferenceTermCode());
        if (openmrsConceptReferenceTerm == null) {
            ConceptSource conceptSource = this.conceptService.getConceptSourceByName(conceptReferenceTerm.getReferenceTermSource());
            openmrsConceptReferenceTerm = new ConceptReferenceTerm(conceptSource, conceptReferenceTerm.getReferenceTermCode(), conceptReferenceTerm.getReferenceTermName());
        } else {
            openmrsConceptReferenceTerm.setName(conceptReferenceTerm.getReferenceTermName());
        }
        openmrsConceptReferenceTerm.setVersion(conceptReferenceTerm.getReferenceVersion());
        openmrsConceptReferenceTerm.setDescription(conceptReferenceTerm.getReferenceDescription());
        return this.conceptService.saveConceptReferenceTerm(openmrsConceptReferenceTerm);
    }

    private ConceptReferenceTerm fetchConceptReferenceTerm(String referenceTermSource, String referenceTermCode) {
        ConceptSource conceptReferenceSource = this.conceptService.getConceptSourceByName(referenceTermSource);
        if (conceptReferenceSource == null) {
            throw new APIException(String.format("Concept reference source %s does not exists.", referenceTermSource));
        }
        return this.conceptService.getConceptReferenceTermByCode(referenceTermCode, conceptReferenceSource);
    }

    private boolean hasReferenceTermAndSource(org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm conceptReferenceTerm) {
        return !StringUtils.isEmpty((CharSequence)conceptReferenceTerm.getReferenceTermCode()) && !StringUtils.isEmpty((CharSequence)conceptReferenceTerm.getReferenceTermSource());
    }

    private void validate(ConceptSource referenceTermSource, ConceptReferenceTerm referenceTerm) {
        StringBuilder errors = new StringBuilder();
        if (referenceTermSource == null) {
            errors.append("Concept reference source not found\n");
        }
        if (referenceTerm == null) {
            errors.append("Concept reference term code not found\n");
        } else if (!referenceTerm.getConceptSource().equals((Object)referenceTermSource)) {
            errors.append("Concept reference term not mapped to the given source\n");
        }
        this.throwExceptionIfExists(errors);
    }

    private void throwExceptionIfExists(StringBuilder errors) {
        String message = errors.toString();
        if (!StringUtils.isBlank((CharSequence)message)) {
            throw new APIException(message);
        }
    }
}

