/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bahmni.module.referencedata.labconcepts.contract.Concept;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptCommon;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptReferenceTerm;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptSet;
import org.bahmni.module.referencedata.labconcepts.contract.Concepts;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptMapper;
import org.bahmni.module.referencedata.labconcepts.mapper.ConceptSetMapper;
import org.bahmni.module.referencedata.labconcepts.model.ConceptMetaData;
import org.bahmni.module.referencedata.labconcepts.service.ConceptMetaDataService;
import org.bahmni.module.referencedata.labconcepts.service.ReferenceDataConceptReferenceTermService;
import org.bahmni.module.referencedata.labconcepts.service.ReferenceDataConceptService;
import org.bahmni.module.referencedata.labconcepts.validator.ConceptValidator;
import org.openmrs.ConceptAnswer;
import org.openmrs.api.ConceptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferenceDataConceptServiceImpl
implements ReferenceDataConceptService {
    private final ConceptMetaDataService conceptMetaDataService;
    private ConceptService conceptService;
    private ReferenceDataConceptReferenceTermService referenceDataConceptReferenceTermService;
    private ConceptMapper conceptMapper = new ConceptMapper();
    private ConceptSetMapper conceptSetMapper = new ConceptSetMapper();
    private final ConceptValidator conceptValidator;
    private List<String> notFound;

    @Autowired
    public ReferenceDataConceptServiceImpl(ConceptService conceptService, ReferenceDataConceptReferenceTermService referenceDataConceptReferenceTermService, ConceptMetaDataService conceptMetaDataService) {
        this.conceptService = conceptService;
        this.referenceDataConceptReferenceTermService = referenceDataConceptReferenceTermService;
        this.conceptMetaDataService = conceptMetaDataService;
        this.conceptValidator = new ConceptValidator();
    }

    @Override
    public org.openmrs.Concept saveConcept(Concept conceptData) {
        ConceptMetaData conceptMetaData = this.conceptMetaDataService.getConceptMetaData(conceptData);
        org.openmrs.Concept mappedConcept = this.getConcept(conceptData, conceptMetaData);
        return this.conceptService.saveConcept(mappedConcept);
    }

    @Override
    public org.openmrs.Concept saveConcept(ConceptSet conceptSet) {
        ConceptMetaData conceptMetaData = this.conceptMetaDataService.getConceptMetaData(conceptSet);
        org.openmrs.Concept mappedConceptSet = this.getConceptSet(conceptSet, conceptMetaData);
        return this.conceptService.saveConcept(mappedConceptSet);
    }

    @Override
    public Concepts getConcept(String conceptName) {
        org.openmrs.Concept concept = this.conceptService.getConceptByName(conceptName);
        if (concept == null) {
            return null;
        }
        Concepts concepts = this.conceptSetMapper.mapAll(concept);
        return concepts;
    }

    private org.openmrs.Concept getConceptSet(ConceptSet conceptSet, ConceptMetaData conceptMetaData) {
        List<org.openmrs.Concept> setMembers = this.getSetMembers(conceptSet.getChildren());
        this.conceptValidator.validate(conceptSet, conceptMetaData.getConceptClass(), conceptMetaData.getConceptDatatype(), this.notFound);
        org.openmrs.Concept mappedConceptSet = this.conceptSetMapper.map(conceptSet, setMembers, conceptMetaData);
        this.clearAndAddConceptMappings(conceptSet, mappedConceptSet);
        return mappedConceptSet;
    }

    private org.openmrs.Concept getConcept(Concept conceptData, ConceptMetaData conceptMetaData) {
        List<ConceptAnswer> conceptAnswers = this.getConceptAnswers(conceptData.getAnswers());
        this.conceptValidator.validate(conceptData, conceptMetaData.getConceptClass(), conceptMetaData.getConceptDatatype(), this.notFound);
        org.openmrs.Concept mappedConcept = this.conceptMapper.map(conceptData, conceptMetaData, conceptAnswers);
        this.clearAndAddConceptMappings(conceptData, mappedConcept);
        return mappedConcept;
    }

    private void clearAndAddConceptMappings(ConceptCommon conceptData, org.openmrs.Concept mappedConcept) {
        Collection conceptMappings = mappedConcept.getConceptMappings();
        conceptMappings.clear();
        mappedConcept.setConceptMappings(conceptMappings);
        for (ConceptReferenceTerm conceptReferenceTerm : conceptData.getConceptReferenceTermsList()) {
            this.conceptMapper.addConceptMap(mappedConcept, this.referenceDataConceptReferenceTermService.getConceptMap(conceptReferenceTerm));
        }
    }

    private List<ConceptAnswer> getConceptAnswers(List<String> answers) {
        ArrayList<ConceptAnswer> conceptAnswers = new ArrayList<ConceptAnswer>();
        this.notFound = new ArrayList<String>();
        if (answers == null) {
            return conceptAnswers;
        }
        for (String answer : answers) {
            org.openmrs.Concept answerConcept = this.conceptService.getConceptByName(answer);
            if (answerConcept == null) {
                this.notFound.add(answer);
            }
            conceptAnswers.add(this.constructConceptAnswer(answerConcept));
        }
        return conceptAnswers;
    }

    private List<org.openmrs.Concept> getSetMembers(List<String> children) {
        ArrayList<org.openmrs.Concept> setMembers = new ArrayList<org.openmrs.Concept>();
        this.notFound = new ArrayList<String>();
        if (children == null) {
            return setMembers;
        }
        for (String child : children) {
            org.openmrs.Concept childConcept = this.conceptService.getConceptByName(child);
            if (childConcept == null) {
                this.notFound.add(child);
            }
            setMembers.add(childConcept);
        }
        return setMembers;
    }

    private ConceptAnswer constructConceptAnswer(org.openmrs.Concept answerConcept) {
        ConceptAnswer conceptAnswer = new ConceptAnswer(answerConcept);
        return conceptAnswer;
    }
}

