/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.service.impl;

import org.bahmni.module.referencedata.labconcepts.mapper.DrugMapper;
import org.bahmni.module.referencedata.labconcepts.model.DrugMetaData;
import org.bahmni.module.referencedata.labconcepts.service.DrugMetaDataService;
import org.bahmni.module.referencedata.labconcepts.service.ReferenceDataDrugService;
import org.bahmni.module.referencedata.labconcepts.validator.DrugValidator;
import org.openmrs.Drug;
import org.openmrs.api.ConceptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferenceDataDrugServiceImpl
implements ReferenceDataDrugService {
    private final DrugValidator drugValidator = new DrugValidator();
    private final ConceptService conceptService;
    private final DrugMetaDataService drugMetaDataService;
    private DrugMapper drugMapper;

    @Autowired
    public ReferenceDataDrugServiceImpl(ConceptService conceptService, DrugMetaDataService drugMetaDataService) {
        this.conceptService = conceptService;
        this.drugMapper = new DrugMapper();
        this.drugMetaDataService = drugMetaDataService;
    }

    @Override
    public Drug saveDrug(org.bahmni.module.referencedata.labconcepts.contract.Drug drug) {
        DrugMetaData drugMetaData = this.drugMetaDataService.getDrugMetaData(drug);
        this.drugValidator.validate(drug, drugMetaData);
        Drug conceptDrug = this.drugMapper.map(drug, drugMetaData);
        return this.conceptService.saveDrug(conceptDrug);
    }
}

