/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.validator;

import java.util.ArrayList;
import java.util.List;
import org.bahmni.module.referencedata.labconcepts.contract.Concept;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptCommon;
import org.bahmni.module.referencedata.labconcepts.contract.ConceptSet;
import org.bahmni.module.referencedata.labconcepts.validator.Validator;
import org.openmrs.ConceptClass;
import org.openmrs.ConceptDatatype;

public class ConceptValidator
extends Validator {
    public void validate(Concept conceptData, ConceptClass conceptClassName, ConceptDatatype conceptDatatype, List<String> notFound) {
        List<String> errors = this.validateConceptCommon(conceptData, conceptClassName, conceptDatatype, notFound);
        if (conceptDatatype != null && !conceptDatatype.isCoded() && this.hasAnswers(conceptData)) {
            errors.add("Cannot create answers for concept " + conceptData.getUniqueName() + " having datatype " + conceptData.getDataType());
        }
        this.throwExceptionIfExists(errors);
    }

    public void validate(ConceptSet conceptSet, ConceptClass conceptClass, ConceptDatatype conceptDatatype, List<String> notFound) {
        List<String> errors = this.validateConceptCommon(conceptSet, conceptClass, conceptDatatype, notFound);
        this.throwExceptionIfExists(errors);
    }

    private List<String> validateConceptCommon(ConceptCommon conceptData, ConceptClass conceptClassName, ConceptDatatype conceptDatatype, List<String> notFound) {
        ArrayList<String> errors = new ArrayList<String>();
        if (conceptClassName == null) {
            errors.add("Concept Class " + conceptData.getClassName() + " not found");
        }
        if (conceptDatatype == null) {
            errors.add("Concept Datatype " + conceptData.getDataType() + " not found");
        }
        for (String notFoundItem : notFound) {
            errors.add(notFoundItem + " Concept/ConceptAnswer not found");
        }
        return errors;
    }

    private boolean hasAnswers(Concept conceptData) {
        return conceptData.getAnswers() != null && conceptData.getAnswers().size() > 0;
    }
}

