/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.module.referencedata.labconcepts.validator;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bahmni.module.referencedata.labconcepts.contract.Drug;
import org.bahmni.module.referencedata.labconcepts.model.DrugMetaData;
import org.bahmni.module.referencedata.labconcepts.validator.DrugMetaDataValidator;
import org.bahmni.module.referencedata.labconcepts.validator.Validator;

public class DrugValidator
extends Validator {
    private final DrugMetaDataValidator drugMetaDataValidator = new DrugMetaDataValidator();

    public void validate(Drug drug, DrugMetaData drugMetaData) {
        this.drugMetaDataValidator.validate(drugMetaData);
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)drug.getUuid()) && drugMetaData.getExistingDrug() == null) {
            errors.add("Drug with provided Uuid does not exist");
        }
        if (StringUtils.isBlank((CharSequence)drug.getName())) {
            errors.add("Drug name is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)drug.getGenericName())) {
            errors.add("Drug generic name is mandatory");
        }
        this.throwExceptionIfExists(errors);
    }
}

