/*
 * Decompiled with CFR 0.152.
 */
package com.monmonkeygroup.openapi.trade;

import com.monmonkeygroup.openapi.Config;
import com.monmonkeygroup.openapi.OpenApiException;
import com.monmonkeygroup.openapi.client.Client;
import com.monmonkeygroup.openapi.client.Profile;
import com.monmonkeygroup.openapi.protocol.Packet;
import com.monmonkeygroup.openapi.trade.AccountSummaryReply;
import com.monmonkeygroup.openapi.trade.AccountSummaryRequest;
import com.monmonkeygroup.openapi.trade.AmendOrderReply;
import com.monmonkeygroup.openapi.trade.AmendOrderRequest;
import com.monmonkeygroup.openapi.trade.CancelOrderRequest;
import com.monmonkeygroup.openapi.trade.CreateOrderReply;
import com.monmonkeygroup.openapi.trade.CreateOrderRequest;
import com.monmonkeygroup.openapi.trade.ListTradeAccountsReply;
import com.monmonkeygroup.openapi.trade.ListTradeAccountsRequest;
import com.monmonkeygroup.openapi.trade.MaxBuyQuantityReply;
import com.monmonkeygroup.openapi.trade.MaxBuyQuantityRequest;
import com.monmonkeygroup.openapi.trade.Order;
import com.monmonkeygroup.openapi.trade.OrderHandler;
import com.monmonkeygroup.openapi.trade.Position;
import com.monmonkeygroup.openapi.trade.PositionReply;
import com.monmonkeygroup.openapi.trade.PositionRequest;
import com.monmonkeygroup.openapi.trade.TodayOrderReply;
import com.monmonkeygroup.openapi.trade.TodayOrderRequest;
import com.monmonkeygroup.openapi.trade.TradeAccount;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeContext
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TradeContext.class);
    private final Config config;
    private final Client client;
    private final Set<String> subscriptions = ConcurrentHashMap.newKeySet();

    public TradeContext(Config config) {
        if (null == config.getTradeAccessToken() || config.getTradeAccessToken().isEmpty()) {
            throw new RuntimeException("don't has tradeAccessToken. please set trade access token");
        }
        Profile profile = new Profile(config.getTradeUrl(), config.getUser(), config.getTradeAccessToken());
        this.config = config;
        this.client = new Client(profile);
        this.client.setAfterConnected(this::afterReconnect);
        try {
            this.client.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void afterReconnect(Client client) {
        try {
            this.resubscribe();
        }
        catch (Exception e) {
            log.error("trade resubscribe error: {}", (Object)e.toString());
        }
    }

    private void resubscribe() throws OpenApiException {
        for (String actionName : this.subscriptions) {
            this.doSubscribe(actionName, true);
        }
    }

    private void doSubscribe(String actionName, boolean isSub) throws OpenApiException {
        Packet packet = Packet.CreateSubscribe(actionName, isSub);
        packet.setActionType("subscribe");
        this.client.sendPacket(packet);
    }

    public void subscribe(List<String> actionNameList) throws OpenApiException {
        for (String actionName : actionNameList) {
            this.doSubscribe(actionName, true);
            this.subscriptions.add(actionName);
        }
    }

    public void unsubscribe(List<String> actionNameList) throws OpenApiException {
        for (String actionName : actionNameList) {
            this.doSubscribe(actionName, false);
            this.subscriptions.remove(actionName);
        }
    }

    public void setOnOrder(OrderHandler handler) {
        if (null == handler) {
            return;
        }
        this.client.addPushHandler("order", packet -> {
            try {
                Order update = packet.deserialize(Order.class);
                handler.onOrder(update);
            }
            catch (Exception e) {
                log.error("order update,unmarshal error: {}", (Object)e.toString());
            }
        });
    }

    public List<TradeAccount> listTradeAccounts() throws OpenApiException {
        ListTradeAccountsRequest request = new ListTradeAccountsRequest();
        ListTradeAccountsReply reply = this.client.doRequest("listTradeAccounts", request, ListTradeAccountsReply.class);
        return reply.getTradeAccounts();
    }

    public AccountSummaryReply getAccountSummary(String tradeAccountId) throws OpenApiException {
        AccountSummaryRequest request = new AccountSummaryRequest(tradeAccountId);
        return this.client.doRequest("getAccountSummary", request, AccountSummaryReply.class);
    }

    public List<Position> getPosition(String tradeAccountId) throws OpenApiException {
        PositionRequest request = new PositionRequest(tradeAccountId);
        PositionReply reply = this.client.doRequest("getPositionSummary", request, PositionReply.class);
        return reply.getApiPositions();
    }

    public Order createOrder(CreateOrderRequest request) throws OpenApiException {
        CreateOrderReply reply = this.client.doRequest("createOrder", request, CreateOrderReply.class);
        return reply.getOrder();
    }

    public void amendOrder(AmendOrderRequest request) throws OpenApiException {
        this.client.doRequest("amendOrder", request, AmendOrderReply.class);
    }

    public void cancelOrder(CancelOrderRequest request) throws OpenApiException {
        this.client.doRequest("cancelOrder", request, CancelOrderRequest.class);
    }

    public List<Order> getTodayOrders(TodayOrderRequest request) throws OpenApiException {
        TodayOrderReply reply = this.client.doRequest("getTodayOrders", request, TodayOrderReply.class);
        return reply.getOrders();
    }

    public MaxBuyQuantityReply getMaxBuyQuantity(MaxBuyQuantityRequest request) throws OpenApiException {
        return this.client.doRequest("maxBuyQuantityEnquiry", request, MaxBuyQuantityReply.class);
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

