package com.monmonkeygroup.openapi.trade;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AmendOrderRequest {
    private String tradeAccountId;
    private String orderId;
    private Double price;
    private Double qty;

    public AmendOrderRequest(String tradeAccountId, String orderId) {
        this.tradeAccountId = tradeAccountId;
        this.orderId = orderId;
    }

    public String getTradeAccountId() {
        return tradeAccountId;
    }

    public AmendOrderRequest setTradeAccountId(String tradeAccountId) {
        this.tradeAccountId = tradeAccountId;
        return this;
    }

    public String getOrderId() {
        return orderId;
    }

    public AmendOrderRequest setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public Double getPrice() {
        return price;
    }

    public AmendOrderRequest setPrice(Double price) {
        this.price = price;
        return this;
    }

    public Double getQty() {
        return qty;
    }

    public AmendOrderRequest setQty(Double qty) {
        this.qty = qty;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
