/*
 * Decompiled with CFR 0.152.
 */
package feign.http2client;

import feign.AsyncClient;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Http2Client
implements Client,
AsyncClient<Object> {
    private final HttpClient client;
    private static final Set<String> DISALLOWED_HEADERS_SET;

    public Http2Client() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofMillis(10000L)).build());
    }

    public Http2Client(Request.Options options) {
        this(Http2Client.newClientBuilder(options).version(HttpClient.Version.HTTP_2).build());
    }

    public Http2Client(HttpClient client) {
        this.client = (HttpClient)Util.checkNotNull((Object)client, (String)"HttpClient must not be null", (Object[])new Object[0]);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpResponse<byte[]> httpResponse;
        HttpRequest httpRequest;
        try {
            httpRequest = this.newRequestBuilder(request, options).version(this.client.version()).build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid uri " + request.url(), e);
        }
        HttpClient clientForRequest = this.getOrCreateClient(options);
        try {
            httpResponse = clientForRequest.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return this.toFeignResponse(request, httpResponse);
    }

    public CompletableFuture<Response> execute(Request request, Request.Options options, Optional<Object> requestContext) {
        HttpRequest httpRequest;
        try {
            httpRequest = this.newRequestBuilder(request, options).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri " + request.url(), e);
        }
        HttpClient clientForRequest = this.getOrCreateClient(options);
        CompletableFuture<HttpResponse<byte[]>> future = clientForRequest.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        return future.thenApply(httpResponse -> this.toFeignResponse(request, (HttpResponse<byte[]>)httpResponse));
    }

    protected Response toFeignResponse(Request request, HttpResponse<byte[]> httpResponse) {
        OptionalLong length = httpResponse.headers().firstValueAsLong("Content-Length");
        return Response.builder().protocolVersion((Request.ProtocolVersion)Util.enumForName(Request.ProtocolVersion.class, (Object)((Object)httpResponse.version()))).body((InputStream)new ByteArrayInputStream(httpResponse.body()), length.isPresent() ? Integer.valueOf((int)length.getAsLong()) : null).reason((String)httpResponse.headers().firstValue("Reason-Phrase").orElse(null)).request(request).status(httpResponse.statusCode()).headers(this.castMapCollectType(httpResponse.headers().map())).build();
    }

    private HttpClient getOrCreateClient(Request.Options options) {
        if (this.doesClientConfigurationDiffer(options)) {
            HttpClient.Builder builder = Http2Client.newClientBuilder(options).sslContext(this.client.sslContext()).sslParameters(this.client.sslParameters()).version(this.client.version());
            this.client.authenticator().ifPresent(builder::authenticator);
            this.client.cookieHandler().ifPresent(builder::cookieHandler);
            this.client.executor().ifPresent(builder::executor);
            this.client.proxy().ifPresent(builder::proxy);
            return builder.build();
        }
        return this.client;
    }

    private boolean doesClientConfigurationDiffer(Request.Options options) {
        if (this.client.followRedirects() == HttpClient.Redirect.ALWAYS != options.isFollowRedirects()) {
            return true;
        }
        return this.client.connectTimeout().map(timeout -> timeout.toMillis() != (long)options.connectTimeoutMillis()).orElse(true);
    }

    private static HttpClient.Builder newClientBuilder(Request.Options options) {
        return HttpClient.newBuilder().followRedirects(options.isFollowRedirects() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).connectTimeout(Duration.ofMillis(options.connectTimeoutMillis()));
    }

    private HttpRequest.Builder newRequestBuilder(Request request, Request.Options options) throws URISyntaxException {
        URI uri = new URI(request.url());
        byte[] data = request.body();
        HttpRequest.BodyPublisher body = data == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray(data);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(options.readTimeoutMillis())).version(this.client.version());
        Map<String, Collection<String>> headers = this.filterRestrictedHeaders(request.headers());
        if (!headers.isEmpty()) {
            requestBuilder.headers(this.asString(headers));
        }
        return requestBuilder.method(request.httpMethod().toString(), body);
    }

    private Map<String, Collection<String>> filterRestrictedHeaders(Map<String, Collection<String>> headers) {
        Map<String, Collection<String>> filteredHeaders = headers.keySet().stream().filter(headerName -> !DISALLOWED_HEADERS_SET.contains(headerName)).collect(Collectors.toMap(Function.identity(), headers::get));
        filteredHeaders.computeIfAbsent("Accept", key -> List.of("*/*"));
        return filteredHeaders;
    }

    private Map<String, Collection<String>> castMapCollectType(Map<String, List<String>> map) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        map.forEach((key, value) -> result.put((String)key, new HashSet(value)));
        return result;
    }

    private String[] asString(Map<String, Collection<String>> headers) {
        return (String[])headers.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(value -> Arrays.asList((String)entry.getKey(), value)).flatMap(Collection::stream)).toArray(String[]::new);
    }

    static {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(Set.of("connection", "content-length", "date", "expect", "from", "host", "origin", "referer", "upgrade", "via", "warning"));
        DISALLOWED_HEADERS_SET = Collections.unmodifiableSet(treeSet);
    }
}

