/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.multitouchgestures.event;

import javax.swing.JComponent;

public class GestureEvent {
    private final JComponent source;
    private final double mouseX;
    private final double mouseY;
    private final double absMouseX;
    private final double absMouseY;
    private final Phase phase;

    public GestureEvent(JComponent source, double mouseX, double mouseY, double absMouseX, double absMouseY, Phase phase) {
        this.source = source;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.absMouseX = absMouseX;
        this.absMouseY = absMouseY;
        this.phase = phase;
    }

    public JComponent getSource() {
        return this.source;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public double getAbsMouseX() {
        return this.absMouseX;
    }

    public double getAbsMouseY() {
        return this.absMouseY;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public static enum Phase {
        MOMENTUM(0),
        BEGIN(1),
        CHANGED(2),
        END(3),
        CANCELLED(4),
        OTHER(-1);

        private final int code;

        private Phase(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Phase getByCode(int code) {
            for (Phase p : Phase.values()) {
                if (p.getCode() != code) continue;
                return p;
            }
            return OTHER;
        }
    }

    public static enum Subtype {
        MOUSE,
        TABLET;

    }
}

