/*
 * Decompiled with CFR 0.152.
 */
package io.javarig;

import io.javarig.ParameterizedTypeImpl;
import io.javarig.TypeGeneratorFactory;
import io.javarig.config.Configuration;
import io.javarig.exception.InstanceGenerationException;
import io.javarig.exception.NestedObjectRecursionException;
import io.javarig.generator.TypeGenerator;
import java.lang.reflect.Type;
import java.util.Stack;
import lombok.NonNull;

public class RandomInstanceGenerator {
    private final Stack<Type> objectStack = new Stack();
    private final TypeGeneratorFactory typeGeneratorFactory = new TypeGeneratorFactory();
    private final Configuration generalConfig;
    private Configuration oneTimeConfig = null;

    public RandomInstanceGenerator() {
        this.generalConfig = Configuration.builder().build();
    }

    public <T> T generate(@NonNull Type objectType) throws InstanceGenerationException {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        this.checkForRecursion(objectType);
        this.objectStack.push(objectType);
        TypeGenerator generator = this.typeGeneratorFactory.getGenerator(objectType, this);
        Object generated = generator.generate();
        this.objectStack.pop();
        return (T)generated;
    }

    public <T> T generate(@NonNull Type objectType, Configuration oneTimeConfig) throws InstanceGenerationException {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        return this.generateWithOneTimeConfig(objectType, oneTimeConfig);
    }

    public <T> T generate(@NonNull Type objectType, Type ... genericTypes) throws InstanceGenerationException {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (genericTypes == null) {
            throw new NullPointerException("genericTypes is marked non-null but is null");
        }
        ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(genericTypes, (Class)objectType);
        return this.generate(parameterizedType);
    }

    public <T> T generate(@NonNull Type objectType, Configuration oneTimeConfig, Type ... genericTypes) throws InstanceGenerationException {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (genericTypes == null) {
            throw new NullPointerException("genericTypes is marked non-null but is null");
        }
        ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(genericTypes, (Class)objectType);
        return this.generate((Type)parameterizedType, oneTimeConfig);
    }

    private <T> T generateWithOneTimeConfig(@NonNull Type objectType, Configuration oneTimeConfig) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        this.oneTimeConfig = oneTimeConfig;
        T generatedObject = this.generate(objectType);
        this.oneTimeConfig = null;
        return generatedObject;
    }

    private void checkForRecursion(Type objectType) {
        if (!this.objectStack.isEmpty() && this.objectStack.contains(objectType)) {
            throw new NestedObjectRecursionException(objectType);
        }
    }

    public RandomInstanceGenerator(Configuration generalConfig) {
        this.generalConfig = generalConfig;
    }

    public Stack<Type> getObjectStack() {
        return this.objectStack;
    }

    public TypeGeneratorFactory getTypeGeneratorFactory() {
        return this.typeGeneratorFactory;
    }

    public Configuration getGeneralConfig() {
        return this.generalConfig;
    }

    public Configuration getOneTimeConfig() {
        return this.oneTimeConfig;
    }
}

