/*
 * Decompiled with CFR 0.152.
 */
package io.javarig.config;

import org.apache.commons.lang3.Validate;

public class Configuration {
    private int maxSizeExclusive;
    private int minSizeInclusive;

    public static Configuration withSize(int size) {
        Configuration.validateSize(size);
        return Configuration.builder().maxSizeExclusive(size + 1).minSizeInclusive(size).build();
    }

    public static Configuration withSize(int minSizeInclusive, int maxSizeExclusive) {
        Configuration.validateSize(minSizeInclusive, maxSizeExclusive);
        return Configuration.builder().maxSizeExclusive(maxSizeExclusive + 1).minSizeInclusive(minSizeInclusive).build();
    }

    private static void validateSize(int minSizeInclusive, int maxSizeExclusive) {
        Validate.isTrue((maxSizeExclusive > minSizeInclusive ? 1 : 0) != 0, (String)"Start value must be smaller than end value.", (Object[])new Object[0]);
        Validate.isTrue((minSizeInclusive >= 0 ? 1 : 0) != 0, (String)"Both range values must be non-negative.", (Object[])new Object[0]);
    }

    private static void validateSize(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"Size must be non-negative.", (Object[])new Object[0]);
    }

    private static int $default$maxSizeExclusive() {
        return 15;
    }

    private static int $default$minSizeInclusive() {
        return 5;
    }

    Configuration(int maxSizeExclusive, int minSizeInclusive) {
        this.maxSizeExclusive = maxSizeExclusive;
        this.minSizeInclusive = minSizeInclusive;
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public int getMaxSizeExclusive() {
        return this.maxSizeExclusive;
    }

    public int getMinSizeInclusive() {
        return this.minSizeInclusive;
    }

    public static class ConfigurationBuilder {
        private boolean maxSizeExclusive$set;
        private int maxSizeExclusive$value;
        private boolean minSizeInclusive$set;
        private int minSizeInclusive$value;

        ConfigurationBuilder() {
        }

        public ConfigurationBuilder maxSizeExclusive(int maxSizeExclusive) {
            this.maxSizeExclusive$value = maxSizeExclusive;
            this.maxSizeExclusive$set = true;
            return this;
        }

        public ConfigurationBuilder minSizeInclusive(int minSizeInclusive) {
            this.minSizeInclusive$value = minSizeInclusive;
            this.minSizeInclusive$set = true;
            return this;
        }

        public Configuration build() {
            int maxSizeExclusive$value = this.maxSizeExclusive$value;
            if (!this.maxSizeExclusive$set) {
                maxSizeExclusive$value = Configuration.$default$maxSizeExclusive();
            }
            int minSizeInclusive$value = this.minSizeInclusive$value;
            if (!this.minSizeInclusive$set) {
                minSizeInclusive$value = Configuration.$default$minSizeInclusive();
            }
            return new Configuration(maxSizeExclusive$value, minSizeInclusive$value);
        }

        public String toString() {
            return "Configuration.ConfigurationBuilder(maxSizeExclusive$value=" + this.maxSizeExclusive$value + ", minSizeInclusive$value=" + this.minSizeInclusive$value + ")";
        }
    }
}

