/*
 * Decompiled with CFR 0.152.
 */
package io.javarig.generator;

import io.javarig.ParameterizedTypeImpl;
import io.javarig.RandomInstanceGenerator;
import io.javarig.exception.AbstractClassInstantiationException;
import io.javarig.exception.InstanceGenerationException;
import io.javarig.exception.InvocationSetterException;
import io.javarig.exception.NoAccessibleDefaultConstructorException;
import io.javarig.generator.TypeGenerator;
import io.javarig.util.GenericTypes;
import io.javarig.util.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGenerator
extends TypeGenerator {
    private static final Logger log = LoggerFactory.getLogger(ObjectGenerator.class);
    private static final String SETTER_PREFIX = "set";
    private Map<String, Type> genericTypesMap = new HashMap<String, Type>();

    public ObjectGenerator(Type type, RandomInstanceGenerator randomInstanceGenerator) {
        super(type, randomInstanceGenerator);
    }

    @Override
    public Object generate() throws InstanceGenerationException {
        Class objectClass;
        Type objectType = this.getType();
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            objectClass = (Class)parameterizedType.getRawType();
            this.constructGenericTypesMap(objectClass, parameterizedType);
        } else {
            objectClass = (Class)objectType;
        }
        Object generatedObject = this.getNewObjectInstance(objectClass);
        log.info("generating object of type {} ...", (Object)objectClass.getName());
        this.generateFields(generatedObject, objectClass);
        log.info("created object {}", generatedObject);
        return generatedObject;
    }

    private void constructGenericTypesMap(Class<?> objectClass, ParameterizedType parameterizedType) {
        List<Type> typeParametersValues = Arrays.asList(parameterizedType.getActualTypeArguments());
        List<String> typeParametersKeys = Arrays.stream(objectClass.getTypeParameters()).map(Type::getTypeName).toList();
        this.genericTypesMap = IntStream.range(0, typeParametersKeys.size()).boxed().collect(Collectors.toMap(typeParametersKeys::get, typeParametersValues::get));
    }

    private void generateFields(Object generatedObject, Class<?> objectClass) throws InstanceGenerationException {
        List<Method> setters = ObjectGenerator.getSetters(objectClass);
        setters.forEach(setter -> this.generateFieldWithSetter(generatedObject, objectClass, (Method)setter));
    }

    private static List<Method> getSetters(Class<?> objectClass) {
        return Arrays.stream(objectClass.getMethods()).filter(method -> method.getName().startsWith(SETTER_PREFIX)).toList();
    }

    private void generateFieldWithSetter(Object generatedObject, Class<?> objectClass, Method setter) {
        String fieldName = Utils.getFieldNameFromSetterMethodName(setter.getName(), SETTER_PREFIX);
        try {
            Field field = Utils.getOwnOrInheritedFieldByName(objectClass, fieldName);
            this.generateField(generatedObject, setter, field);
        }
        catch (NoSuchFieldException ignore) {
            log.warn("no such field with name {} for setter {}", (Object)fieldName, (Object)setter.getName());
        }
    }

    private void generateField(Object generatedObject, Method setter, Field field) throws InstanceGenerationException {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            type = this.resolveTypeArguments(parameterizedType);
        }
        Object generatedField = this.getRandomInstanceGenerator().generate(GenericTypes.resolve(type, this.genericTypesMap));
        try {
            setter.invoke(generatedObject, generatedField);
        }
        catch (IllegalAccessException ignore) {
            log.warn("setter {} in class {} is not accessible", (Object)setter.getName(), (Object)generatedObject.getClass().getName());
        }
        catch (InvocationTargetException e) {
            throw new InvocationSetterException(setter.getName(), generatedObject.getClass().getName(), e);
        }
    }

    private Type resolveTypeArguments(Type type) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        List<Type> typeArguments = Arrays.stream(parameterizedType.getActualTypeArguments()).map(typeArgument -> GenericTypes.resolve(typeArgument, this.genericTypesMap)).toList();
        Type[] typeArgumentsArray = new Type[typeArguments.size()];
        return new ParameterizedTypeImpl(typeArguments.toArray(typeArgumentsArray), (Class)((ParameterizedType)type).getRawType());
    }

    private Object getNewObjectInstance(Class<?> objectClass) throws InstanceGenerationException {
        try {
            return objectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InstanceGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoAccessibleDefaultConstructorException(objectClass, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AbstractClassInstantiationException(objectClass.getName(), e);
        }
    }

    public Map<String, Type> getGenericTypesMap() {
        return this.genericTypesMap;
    }

    public void setGenericTypesMap(Map<String, Type> genericTypesMap) {
        this.genericTypesMap = genericTypesMap;
    }
}

