/*
 * Decompiled with CFR 0.152.
 */
package io.javarig.generator.collection;

import io.javarig.RandomInstanceGenerator;
import io.javarig.exception.InstanceGenerationException;
import io.javarig.exception.JavaRIGInternalException;
import io.javarig.generator.TypeGenerator;
import io.javarig.generator.collection.GenericCollectionGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public abstract class SingleGenericTypeCollectionGenerator<T extends Collection>
extends TypeGenerator
implements GenericCollectionGenerator<T> {
    private static final int NUMBER_OF_GENERIC_PARAMS = 1;

    public SingleGenericTypeCollectionGenerator(Type type, RandomInstanceGenerator randomInstanceGenerator) {
        super(type, randomInstanceGenerator);
    }

    @Override
    public int getNumberOfGenericParams() {
        return 1;
    }

    public T generate() throws InstanceGenerationException {
        int randomSize = this.getRandom().nextInt(this.getConfig().getMinSizeInclusive(), this.getConfig().getMaxSizeExclusive());
        this.checkIfValidNumberOfGenericArguments(this.getType());
        ParameterizedType parameterizedType = (ParameterizedType)this.getType();
        Type listParameterType = parameterizedType.getActualTypeArguments()[0];
        return this.generate(listParameterType, randomSize);
    }

    public T generate(Type collectionParameterType, int size) throws InstanceGenerationException {
        T outputList = this.getNewCollectionInstance();
        for (int i = 0; i < size; ++i) {
            outputList.add(this.getRandomInstanceGenerator().generate(collectionParameterType));
        }
        return outputList;
    }

    private T getNewCollectionInstance() throws JavaRIGInternalException {
        try {
            return (T)((Collection)this.getImplementationType().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new JavaRIGInternalException(e);
        }
    }
}

