/*
 * Decompiled with CFR 0.152.
 */
package io.javarig.generator.collection.map;

import io.javarig.RandomInstanceGenerator;
import io.javarig.exception.InstanceGenerationException;
import io.javarig.exception.JavaRIGInternalException;
import io.javarig.generator.TypeGenerator;
import io.javarig.generator.collection.GenericCollectionGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class MapGenerator
extends TypeGenerator
implements GenericCollectionGenerator<Map> {
    private static final int NUMBER_OF_GENERIC_PARAMS = 2;

    public MapGenerator(Type type, RandomInstanceGenerator randomInstanceGenerator) {
        super(type, randomInstanceGenerator);
    }

    @Override
    public int getNumberOfGenericParams() {
        return 2;
    }

    @Override
    public Map<Object, Object> generate() throws InstanceGenerationException {
        this.checkIfValidNumberOfGenericArguments(this.getType());
        int size = this.getRandom().nextInt(this.getConfig().getMinSizeInclusive(), this.getConfig().getMaxSizeExclusive());
        ParameterizedType parameterizedType = (ParameterizedType)this.getType();
        return this.generate(parameterizedType, size);
    }

    private Map<Object, Object> generate(ParameterizedType type, int size) throws InstanceGenerationException {
        Type keyType = type.getActualTypeArguments()[0];
        Type valueType = type.getActualTypeArguments()[1];
        Map<Object, Object> resultedMap = this.getNewMapInstance();
        for (int i = 0; i < size; ++i) {
            resultedMap.put(this.getRandomInstanceGenerator().generate(keyType), this.getRandomInstanceGenerator().generate(valueType));
        }
        return resultedMap;
    }

    private Map<Object, Object> getNewMapInstance() {
        try {
            return (Map)this.getImplementationType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new JavaRIGInternalException(e);
        }
    }
}

