/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.handlers;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import net.phoenix.handlers.AbstractHandler;
import org.jetbrains.annotations.NotNull;

public class FieldHandler
extends AbstractHandler {
    private final RoundEnvironment roundEnv;

    public FieldHandler(Trees trees, TreeMaker treeMaker, Context context, RoundEnvironment roundEnv) {
        super(trees, treeMaker, context);
        this.roundEnv = roundEnv;
    }

    @Override
    public void handle(Element element) {
        JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)this.trees.getTree(element);
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this.trees.getPath(element).getCompilationUnit().getTypeDecls().get(0);
        variableDecl.init = this.initGen(variableDecl);
        for (JCTree.JCClassDecl classes : this.roundEnv.getRootElements().stream().map(e -> (JCTree.JCClassDecl)this.trees.getTree((Element)e)).toList()) {
            if (classes == classDecl) continue;
            classes.defs.forEach(m -> {
                JCTree.JCMethodDecl methodDecl;
                if (m instanceof JCTree.JCMethodDecl && this.shouldInject(methodDecl = (JCTree.JCMethodDecl)m, variableDecl)) {
                    this.modifyMethod(methodDecl, variableDecl, classes);
                }
            });
        }
    }

    private boolean shouldInject(JCTree.JCMethodDecl methodDecl, final  @NotNull JCTree.JCVariableDecl variableDecl) {
        final boolean[] isReferenced = new boolean[]{false};
        TreeScanner scanner = new TreeScanner(this){
            private final Name name;
            {
                this.name = variableDecl.getName();
            }

            @Override
            public void visitIdent( @NotNull JCTree.JCIdent jcIdent) {
                if (jcIdent.name.equals(this.name)) {
                    isReferenced[0] = true;
                }
                super.visitIdent(jcIdent);
            }
        };
        scanner.scan(methodDecl);
        return isReferenced[0];
    }

    private void modifyMethod( @NotNull JCTree.JCMethodDecl method,  @NotNull JCTree.JCVariableDecl variableDecl,  @NotNull JCTree.JCClassDecl classDecl) {
        method.body.stats = method.body.stats.prepend(this.treeMaker.Exec(this.treeMaker.Assign(this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(classDecl.name), variableDecl.getName()), this.initGen(variableDecl))));
    }

    private JCTree.JCExpression initGen( @NotNull JCTree.JCVariableDecl param) {
        Names names = Names.instance(this.context);
        JCTree.JCFieldAccess paramTypeClassExpr = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(names.fromString(param.vartype.toString())), names.fromString("class"));
        JCTree.JCMethodInvocation methodInvocation = this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(names.fromString("JavaPlusPlus")), names.fromString("getValue")), List.of(paramTypeClassExpr));
        return this.treeMaker.TypeCast(this.treeMaker.Ident(names.fromString(param.vartype.toString())), (JCTree.JCExpression)methodInvocation);
    }
}

