/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.handlers;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import net.phoenix.handlers.AbstractHandler;
import org.jetbrains.annotations.NotNull;

public class InjectParameterHandler
extends AbstractHandler {
    private List<JCTree.JCMethodDecl> handled = List.nil();

    public InjectParameterHandler(Trees trees, TreeMaker treeMaker, Context context) {
        super(trees, treeMaker, context);
    }

    @Override
    public void handle(Element element) {
        VariableElement parameterElement = (VariableElement)element;
        ExecutableElement methodElement = (ExecutableElement)parameterElement.getEnclosingElement();
        JCTree.JCMethodDecl originalMethodDecl = (JCTree.JCMethodDecl)this.trees.getTree(methodElement);
        if (this.handled.contains(originalMethodDecl)) {
            return;
        }
        Names names = Names.instance(this.context);
        JCTree.JCMethodDecl newMethodDecl = this.copy(originalMethodDecl);
        this.sortParams(newMethodDecl, names);
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this.trees.getPath(methodElement).getCompilationUnit().getTypeDecls().get(0);
        classDecl.defs = classDecl.defs.prepend(newMethodDecl);
        this.handled = this.handled.prepend(originalMethodDecl);
    }

    private boolean shouldInject( @NotNull JCTree.JCVariableDecl param) {
        for (JCTree.JCAnnotation annotation : param.mods.annotations) {
            if (!Objects.equals(annotation.getAnnotationType().toString(), "InjectParameter")) continue;
            return true;
        }
        return false;
    }

    private void sortParams( @NotNull JCTree.JCMethodDecl methodDecl, @NotNull Names names) {
        ListBuffer<JCTree.JCVariableDecl> newParams = new ListBuffer<JCTree.JCVariableDecl>();
        for (JCTree.JCVariableDecl param : methodDecl.params) {
            if (this.shouldInject(param)) {
                methodDecl.body.stats = methodDecl.body.stats.prepend(this.setValue(param, names));
                continue;
            }
            newParams.append(param);
        }
        methodDecl.params = newParams.toList();
    }

    private JCTree.JCMethodDecl copy( @NotNull JCTree.JCMethodDecl method) {
        return this.treeMaker.MethodDef(method.mods, method.name, method.restype, method.typarams, method.params, method.thrown, method.body, method.defaultValue);
    }

    private JCTree.JCVariableDecl setValue( @NotNull JCTree.JCVariableDecl param, @NotNull Names names) {
        JCTree.JCFieldAccess paramTypeClassExpr = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(names.fromString(param.vartype.toString())), names.fromString("class"));
        JCTree.JCMethodInvocation methodInvocation = this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(names.fromString("JavaPlusPlus")), names.fromString("getValue")), List.of(paramTypeClassExpr));
        JCTree.JCTypeCast typeCastExpr = this.treeMaker.TypeCast(this.treeMaker.Ident(names.fromString(param.vartype.toString())), (JCTree.JCExpression)methodInvocation);
        return this.treeMaker.VarDef(this.treeMaker.Modifiers(0L), names.fromString(param.getName().toString()), param.vartype, typeCastExpr);
    }
}

