/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.handlers;

import com.sun.source.util.Trees;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import net.phoenix.handlers.AbstractHandler;
import org.jetbrains.annotations.NotNull;

public class NotNullHandler
extends AbstractHandler {
    public NotNullHandler(Trees trees, TreeMaker treeMaker, Context context) {
        super(trees, treeMaker, context);
    }

    @Override
    public void handle(Element element) {
        VariableElement parameterElement = (VariableElement)element;
        ExecutableElement methodElement = (ExecutableElement)parameterElement.getEnclosingElement();
        JCTree.JCMethodDecl originalMethodDecl = (JCTree.JCMethodDecl)this.trees.getTree(methodElement);
        Names names = Names.instance(this.context);
        this.addNullCheck(originalMethodDecl, (JCTree.JCVariableDecl)this.trees.getTree(parameterElement), names);
    }

    public void addNullCheck( @NotNull JCTree.JCMethodDecl methodDecl,  @NotNull JCTree.JCVariableDecl variableDecl, @NotNull Names names) {
        Name varName = names.fromString(variableDecl.getName().toString());
        JCTree.JCIdent varIdent = this.treeMaker.Ident(varName);
        JCTree.JCLiteral nullLiteral = this.treeMaker.Literal(TypeTag.BOT, null);
        JCTree.JCBinary nullCheck = this.treeMaker.Binary(JCTree.Tag.NE, varIdent, nullLiteral);
        JCTree.JCStatement throwStatement = this.createThrowStatement(this.treeMaker, names);
        JCTree.JCIf ifStatement = this.treeMaker.If(nullCheck, throwStatement, null);
        methodDecl.body.stats = methodDecl.body.stats.prepend(ifStatement);
    }

    public JCTree.JCStatement createThrowStatement(@NotNull TreeMaker treeMaker, @NotNull Names names) {
        JCTree.JCIdent exceptionClass = treeMaker.Ident(names.fromString("NullPointerException"));
        JCTree.JCNewClass newException = treeMaker.NewClass(null, List.nil(), exceptionClass, List.nil(), null);
        return treeMaker.Throw(newException);
    }
}

