package pluginloader.api

typealias Args = Array<String>

/**
 * Register crossplatform command. Command can be used only with privileged access
 * See also [LoaderPlugin.cmd]
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Cmd("command", aliases = ["alias"])
 * internal fun cmd(sender: CmdSender, args: Args){}
 * ```
 * @param sender [CmdSender]
 * @param args [Args] /example a b -> arrayOf("a", "b")
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Cmd(val command: String, val aliases: Array<String> = [])

/**
 * Crossplatform command executor
 */
interface CmdSender{
    fun sendMessage(string: String)
}