/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

public class ImagePropertiesSize
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_UNPACKED = "Unpacked";
    @SerializedName(value="Unpacked")
    private Long unpacked;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ImagePropertiesSize unpacked(Long unpacked) {
        this.unpacked = unpacked;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Unpacked is the size (in bytes) of the locally unpacked (uncompressed) image content that's directly usable by the containers running this image. It's independent of the distributable content - e.g. the image might still have an unpacked data that's still used by some container even when the distributable/compressed content is already gone.")
    public Long getUnpacked() {
        return this.unpacked;
    }

    public void setUnpacked(Long unpacked) {
        this.unpacked = unpacked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagePropertiesSize imagePropertiesSize = (ImagePropertiesSize)o;
        return Objects.equals(this.unpacked, imagePropertiesSize.unpacked);
    }

    public int hashCode() {
        return Objects.hash(this.unpacked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImagePropertiesSize {\n");
        sb.append("    unpacked: ").append(this.toIndentedString(this.unpacked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ImagePropertiesSize is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ImagePropertiesSize` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static ImagePropertiesSize fromJson(String jsonString) throws IOException {
        return (ImagePropertiesSize)JSON.getGson().fromJson(jsonString, ImagePropertiesSize.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UNPACKED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_UNPACKED);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ImagePropertiesSize.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ImagePropertiesSize.class));
            return new TypeAdapter<ImagePropertiesSize>(){

                public void write(JsonWriter out, ImagePropertiesSize value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ImagePropertiesSize read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ImagePropertiesSize.validateJsonObject(jsonObj);
                    return (ImagePropertiesSize)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

