/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Topology;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="TopologyRequirement expresses the user's requirements for a volume's accessible topology.")
public class TopologyRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PREFERRED = "Preferred";
    @SerializedName(value="Preferred")
    private List<Topology> preferred = null;
    public static final String SERIALIZED_NAME_REQUISITE = "Requisite";
    @SerializedName(value="Requisite")
    private List<Topology> requisite = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TopologyRequirement preferred(List<Topology> preferred) {
        this.preferred = preferred;
        return this;
    }

    public TopologyRequirement addPreferredItem(Topology preferredItem) {
        if (this.preferred == null) {
            this.preferred = new ArrayList<Topology>();
        }
        this.preferred.add(preferredItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Preferred is a list of Topologies that the volume should attempt to be provisioned in.  Taken from the CSI spec:  Specifies the list of topologies the CO would prefer the volume to be provisioned in.  This field is OPTIONAL. If TopologyRequirement is specified either requisite or preferred or both MUST be specified.  An SP MUST attempt to make the provisioned volume available using the preferred topologies in order from first to last.  If requisite is specified, all topologies in preferred list MUST also be present in the list of requisite topologies.  If the SP is unable to make the provisioned volume available from any of the preferred topologies, the SP MAY choose a topology from the list of requisite topologies. If the list of requisite topologies is not specified, then the SP MAY choose from the list of all possible topologies. If the list of requisite topologies is specified and the SP is unable to make the provisioned volume available from any of the requisite topologies it MUST fail the CreateVolume call.  Example 1: Given a volume should be accessible from a single zone, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"} preferred = {\"region\": \"R1\", \"zone\": \"Z3\"} then the SP SHOULD first attempt to make the provisioned volume available from \"zone\" \"Z3\" in the \"region\" \"R1\" and fall back to \"zone\" \"Z2\" in the \"region\" \"R1\" if that is not possible.  Example 2: Given a volume should be accessible from a single zone, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"}, {\"region\": \"R1\", \"zone\": \"Z4\"}, {\"region\": \"R1\", \"zone\": \"Z5\"} preferred = {\"region\": \"R1\", \"zone\": \"Z4\"}, {\"region\": \"R1\", \"zone\": \"Z2\"} then the SP SHOULD first attempt to make the provisioned volume accessible from \"zone\" \"Z4\" in the \"region\" \"R1\" and fall back to \"zone\" \"Z2\" in the \"region\" \"R1\" if that is not possible. If that is not possible, the SP may choose between either the \"zone\" \"Z3\" or \"Z5\" in the \"region\" \"R1\".  Example 3: Given a volume should be accessible from TWO zones (because an opaque parameter in CreateVolumeRequest, for example, specifies the volume is accessible from two zones, aka synchronously replicated), and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"}, {\"region\": \"R1\", \"zone\": \"Z4\"}, {\"region\": \"R1\", \"zone\": \"Z5\"} preferred = {\"region\": \"R1\", \"zone\": \"Z5\"}, {\"region\": \"R1\", \"zone\": \"Z3\"} then the SP SHOULD first attempt to make the provisioned volume accessible from the combination of the two \"zones\" \"Z5\" and \"Z3\" in the \"region\" \"R1\". If that's not possible, it should fall back to a combination of \"Z5\" and other possibilities from the list of requisite. If that's not possible, it should fall back  to a combination of \"Z3\" and other possibilities from the list of requisite. If that's not possible, it should fall back  to a combination of other possibilities from the list of requisite.")
    public List<Topology> getPreferred() {
        return this.preferred;
    }

    public void setPreferred(List<Topology> preferred) {
        this.preferred = preferred;
    }

    public TopologyRequirement requisite(List<Topology> requisite) {
        this.requisite = requisite;
        return this;
    }

    public TopologyRequirement addRequisiteItem(Topology requisiteItem) {
        if (this.requisite == null) {
            this.requisite = new ArrayList<Topology>();
        }
        this.requisite.add(requisiteItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Requisite specifies a list of Topologies, at least one of which the volume must be accessible from.  Taken verbatim from the CSI Spec:  Specifies the list of topologies the provisioned volume MUST be accessible from. This field is OPTIONAL. If TopologyRequirement is specified either requisite or preferred or both MUST be specified.  If requisite is specified, the provisioned volume MUST be accessible from at least one of the requisite topologies.  Given x = number of topologies provisioned volume is accessible from n = number of requisite topologies The CO MUST ensure n >= 1. The SP MUST ensure x >= 1 If x==n, then the SP MUST make the provisioned volume available to all topologies from the list of requisite topologies. If it is unable to do so, the SP MUST fail the CreateVolume call. For example, if a volume should be accessible from a single zone, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"} then the provisioned volume MUST be accessible from the \"region\" \"R1\" and the \"zone\" \"Z2\". Similarly, if a volume should be accessible from two zones, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"} then the provisioned volume MUST be accessible from the \"region\" \"R1\" and both \"zone\" \"Z2\" and \"zone\" \"Z3\".  If x<n, then the SP SHALL choose x unique topologies from the list of requisite topologies. If it is unable to do so, the SP MUST fail the CreateVolume call. For example, if a volume should be accessible from a single zone, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"} then the SP may choose to make the provisioned volume available in either the \"zone\" \"Z2\" or the \"zone\" \"Z3\" in the \"region\" \"R1\". Similarly, if a volume should be accessible from two zones, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"}, {\"region\": \"R1\", \"zone\": \"Z3\"}, {\"region\": \"R1\", \"zone\": \"Z4\"} then the provisioned volume MUST be accessible from any combination of two unique topologies: e.g. \"R1/Z2\" and \"R1/Z3\", or \"R1/Z2\" and \"R1/Z4\", or \"R1/Z3\" and \"R1/Z4\".  If x>n, then the SP MUST make the provisioned volume available from all topologies from the list of requisite topologies and MAY choose the remaining x-n unique topologies from the list of all possible topologies. If it is unable to do so, the SP MUST fail the CreateVolume call. For example, if a volume should be accessible from two zones, and requisite = {\"region\": \"R1\", \"zone\": \"Z2\"} then the provisioned volume MUST be accessible from the \"region\" \"R1\" and the \"zone\" \"Z2\" and the SP may select the second zone independently, e.g. \"R1/Z4\".")
    public List<Topology> getRequisite() {
        return this.requisite;
    }

    public void setRequisite(List<Topology> requisite) {
        this.requisite = requisite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyRequirement topologyRequirement = (TopologyRequirement)o;
        return Objects.equals(this.preferred, topologyRequirement.preferred) && Objects.equals(this.requisite, topologyRequirement.requisite);
    }

    public int hashCode() {
        return Objects.hash(this.preferred, this.requisite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyRequirement {\n");
        sb.append("    preferred: ").append(this.toIndentedString(this.preferred)).append("\n");
        sb.append("    requisite: ").append(this.toIndentedString(this.requisite)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayrequisite;
        JsonArray jsonArraypreferred;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TopologyRequirement is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TopologyRequirement` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREFERRED) != null && !jsonObj.get(SERIALIZED_NAME_PREFERRED).isJsonNull() && (jsonArraypreferred = jsonObj.getAsJsonArray(SERIALIZED_NAME_PREFERRED)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PREFERRED).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Preferred` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREFERRED).toString()));
            }
            for (int i = 0; i < jsonArraypreferred.size(); ++i) {
                Topology.validateJsonObject(jsonArraypreferred.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUISITE) != null && !jsonObj.get(SERIALIZED_NAME_REQUISITE).isJsonNull() && (jsonArrayrequisite = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUISITE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUISITE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Requisite` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUISITE).toString()));
            }
            for (int i = 0; i < jsonArrayrequisite.size(); ++i) {
                Topology.validateJsonObject(jsonArrayrequisite.get(i).getAsJsonObject());
            }
        }
    }

    public static TopologyRequirement fromJson(String jsonString) throws IOException {
        return (TopologyRequirement)JSON.getGson().fromJson(jsonString, TopologyRequirement.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PREFERRED);
        openapiFields.add(SERIALIZED_NAME_REQUISITE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TopologyRequirement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TopologyRequirement.class));
            return new TypeAdapter<TopologyRequirement>(){

                public void write(JsonWriter out, TopologyRequirement value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TopologyRequirement read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TopologyRequirement.validateJsonObject(jsonObj);
                    return (TopologyRequirement)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

