/*
 * Decompiled with CFR 0.152.
 */
package io.github.punchplatform.api.punchline.java;

import io.github.punchplatform.api.punchline.Column;
import io.github.punchplatform.api.punchline.Out;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row {
    private static final Logger log = LoggerFactory.getLogger(Row.class);
    protected final long uuid;
    protected final List<Object> values;
    protected final String originatorRuntimeId;
    private List<Column> columns;
    private final Out out;

    public Row(Out out, List<Object> values) {
        this.out = out;
        this.values = values;
        this.columns = out.columns;
        this.originatorRuntimeId = "";
        this.uuid = 0L;
    }

    public Row(Out out, List<Object> values, List<Column> columns, String originatorRuntimeId, long uuid) {
        this.out = out;
        this.values = values;
        this.columns = columns;
        this.originatorRuntimeId = originatorRuntimeId;
        this.uuid = uuid;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Out getTableId() {
        return this.out;
    }

    public long getUuid() {
        return this.uuid;
    }

    public int size() {
        return this.values.size();
    }

    public int columnIndex(String column) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get((int)i).name.equals(column)) continue;
            return i;
        }
        throw new IllegalArgumentException(column + " does not exist");
    }

    public boolean contains(String column) {
        for (Column c : this.getColumns()) {
            if (!c.name.equals(column)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(int i) {
        return this.values.get(i);
    }

    public String getString(int i) {
        return (String)this.values.get(i);
    }

    public Integer getInteger(int i) {
        return (Integer)this.values.get(i);
    }

    public Long getLong(int i) {
        return (Long)this.values.get(i);
    }

    public Boolean getBoolean(int i) {
        return (Boolean)this.values.get(i);
    }

    public Short getShort(int i) {
        return (Short)this.values.get(i);
    }

    public Byte getByte(int i) {
        return (Byte)this.values.get(i);
    }

    public Double getDouble(int i) {
        return (Double)this.values.get(i);
    }

    public Float getFloat(int i) {
        return (Float)this.values.get(i);
    }

    public byte[] getBinary(int i) {
        return (byte[])this.values.get(i);
    }

    public Object getValueByColumn(Column column) {
        return this.getValueByColumn(column.name);
    }

    public Object getValueByColumn(String column) {
        try {
            return this.values.get(this.columnIndex(column));
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException(String.format("missing column '%s' in incoming row. Available columns are '%s'. Check your input node 'out' configuration", column, this.getColumns()));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("missing column '%s' in incoming tuple. Available columns are '%s'. Check your input node 'out' configuration", column, this.getColumns()));
        }
    }

    public String getStringByColumnName(String column) {
        return (String)this.values.get(this.columnIndex(column));
    }

    public Integer getIntegerByColumn(String column) {
        return (Integer)this.values.get(this.columnIndex(column));
    }

    public Long getLongByColumn(String column) {
        return (Long)this.values.get(this.columnIndex(column));
    }

    public Boolean getBooleanByColumn(String column) {
        return (Boolean)this.values.get(this.columnIndex(column));
    }

    public Short getShortByColumn(String column) {
        return (Short)this.values.get(this.columnIndex(column));
    }

    public Byte getByteByColumn(String column) {
        return (Byte)this.values.get(this.columnIndex(column));
    }

    public Double getDoubleByColumn(String column) {
        return (Double)this.values.get(this.columnIndex(column));
    }

    public Float getFloatByColumn(String column) {
        return (Float)this.values.get(this.columnIndex(column));
    }

    public byte[] getBinaryByColumn(String column) {
        return (byte[])this.values.get(this.columnIndex(column));
    }

    public List<Object> getValues() {
        return this.values;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Object> select(List<Column> selector) {
        ArrayList<Object> ret = new ArrayList<Object>(selector.size());
        for (Column s : selector) {
            ret.add(this.values.get(this.columnIndex(s.name)));
        }
        return ret;
    }

    public boolean isTickRow() {
        return false;
    }

    public void validate() throws RuntimeException {
        if (this.columns.size() != this.values.size()) {
            throw new RuntimeException("invalid row with '" + this.columns.size() + "' columns but '" + this.values.size() + "' values");
        }
    }

    public void dump() {
        log.info("columns {} value {}", (Object)this.columns.size(), (Object)this.values.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            log.info("columns {} value {}", (Object)this.columns.get(i), this.values.get(i));
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            map.put(this.columns.get((int)i).name, this.values.get(i));
        }
        return map;
    }

    public Row removeColumn(String topicColumn) {
        try {
            int index = this.columnIndex(topicColumn);
            this.values.remove(index);
            this.columns = Row.removeColumn(this.columns, index);
        }
        catch (Exception e) {
            throw new RuntimeException("column " + topicColumn + " not found in row " + this);
        }
        return this;
    }

    private static List<Column> removeColumn(List<Column> columns, int index) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (int i = 0; i < columns.size(); ++i) {
            if (i == index) continue;
            result.add(columns.get(i));
        }
        return result;
    }
}

